package com.elitesland.tw.tw5.api.prd.my.vo;

import lombok.Data;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;

@Data
public class MobAttendanceVO {

    private Long attendanceNormalId;  //打卡ID

    private Long attendanceResId;

    private Long attendanceRuleId;//规则ID，T_ATTENDANCE_RULE.ID

    private Long attendanceSiteId;//规则地址,T_ATTENDANCE_SITE.ID

    private String attendanceDevice;//打卡设备

    private String specialReason;//打卡原因

    private String attendanceTimeStart;//上班打卡时间（前端传入，根据规则接口获取）

    private String attendanceTimeEnd;//下班打卡时间（前端传入，根据规则接口获取）

    private String attendanceResult;//打卡结果，UDC（COM:YESNO）

    public String getAttendanceResult() { //根据打卡时间判断是否正常打卡
        if (attendanceRuleId != null && offWork != null) {
            String currentTime = LocalTime.now() == null ? "" : LocalTime.now().format(DateTimeFormatter.ISO_LOCAL_TIME);
            if (offWork && currentTime.compareTo(attendanceTimeEnd) >= 0) { //下班
                return "YES";
            } else if (!offWork && currentTime.compareTo(LocalTime.parse(attendanceTimeStart).plus(1, ChronoUnit.MINUTES).toString()) <= 0) { //
                return "YES";
            } else {
                return "NO";
            }
        }
        return "YES";
    }

    private String attendanceResultDetail;//正常、迟到或早退、矿工，UDC（COM:ATTENDANCE_ATTENDACE_RESULT）

    public String getAttendanceResultDetail() {
        if ("YES".equals(getAttendanceResult())) {
            return AttendanceResultStatus.NORMAL.name;
        }
        String currentTime = LocalTime.now() == null ? "" : LocalTime.now().format(DateTimeFormatter.ISO_LOCAL_TIME);
        if (offWork && currentTime.compareTo(attendanceTimeEnd) < 0) { //下班
            return AttendanceResultStatus.LEAVE_EARLY.name;//早退
        } else if (!offWork && currentTime.compareTo(LocalTime.parse(attendanceTimeStart).plus(1, ChronoUnit.MINUTES).toString()) > 0) {
            return AttendanceResultStatus.BE_LATE.name;//迟到
        } else {
            return AttendanceResultStatus.COMPLETION.name;//旷工
        }
    }

    private enum AttendanceResultStatus {
        NORMAL("NORMAL", "正常"),
        LEAVE_EARLY("LEAVE_EARLY", "早退"),
        BE_LATE("BE_LATE", "迟到"),
        COMPLETION("COMPLETION", "旷工"),
        ;

        private final String name;
        private final String desc;

        AttendanceResultStatus(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }
    }

    private Boolean offWork;//是否下班打卡，false:上班打卡，true:下班打卡

    private String attendanceSiteLongitude;//打卡经度

    private String attendanceSiteLatitude;//打卡维度

    private String attendanceLocation;//打卡位置

    private String punchLimitStartTime; //在此时间前可打上班卡
    private String punchLimitEndTime;  //在此时间前可打下班卡

    //上班打卡限制时间
    private String punchLimitStartSecondTime;

    // 在此时间后可打下班打卡限制卡
    private String punchLimitEndSecondTime;

    /**
     * 允许上班打卡迟到时间
     */
    private int allowLateTimeNum;

    /**
     * 允许下班打卡早退时间
     */
    private int allowLeaveTimeNum;
}
