package com.elitesland.tw.tw5.api.prd.my.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

@Data
public class TAttendanceNormalVO extends BaseViewModel implements Serializable {
    /**
     * 打卡人员ID
     */
    @ApiModelProperty("打卡人员ID")
    private Long attendanceResId;

    @UdcName(udcName = "USER", codePropName = "attendanceResId")
    private String userName;

    /**
     * 打卡人员部门ID
     */
    @ApiModelProperty("打卡人员部门ID")
    private Long orgId;

    @UdcName(udcName = "BU", codePropName = "orgId")
    private String orgName;

    /**
     * 打卡日期
     */
    @ApiModelProperty("打卡日期")
    private LocalDate attendanceDate;

    /**
     * 规则ID
     */
    @ApiModelProperty("规则ID")
    private Long attendanceRuleId;

    /**
     * 规则名称
     */
    @ApiModelProperty("规则名称")
    private String ruleName;

    /**
     * 上班时间
     */
    @ApiModelProperty("上班时间")
    private String attendanceTimeStart;
    /**
     * 下班时间
     */
    @ApiModelProperty("下班时间")
    private String attendanceTimeEnd;

    /**
     * 工作时长
     */
    @ApiModelProperty("工作时长")
    private String attendanceTime;

    @ApiModelProperty("打卡经度")
    private String attendanceSiteLongitude;

    @ApiModelProperty("打卡纬度")
    private String attendanceSiteLatitude;

    @ApiModelProperty("打卡位置")
    private String attendanceLocation;

    @ApiModelProperty("打卡城市")
    private String attendanceCity;

    /**
     * 打卡结果 YSE/NO
     */
    @ApiModelProperty("打卡结果 YSE/NO")
    private String attendanceResult;
    /**
     * 正常、迟到或早退、矿工
     */
    @ApiModelProperty("正常、迟到或早退、矿工")
    private String attendanceResultDetail;

    /**
     * 正常、迟到或早退、矿工
     */
    @ApiModelProperty("正常、迟到或早退、矿工")
    @UdcName(udcName = "prd:attendance:state", codePropName = "attendanceResultDetail")
    private String attendanceResultDetailName;

    /**
     * 特殊打卡原因
     */
    @ApiModelProperty("特殊打卡原因")
    private String specialReason;
    /**
     * 打卡设备
     */
    @ApiModelProperty("打卡设备")
    private String attendanceDevice;

    @ApiModelProperty("主服务地")
    private String baseCity;

    @UdcName(udcName = "org:employee:serviceaddr", codePropName = "baseCity")
    private String baseCityName;

    /**
     * 审批结果
     */
    @ApiModelProperty("审批结果")
    private String approvalResult;

    /**
     * 审批结果
     */
    @ApiModelProperty("审批结果")
    @UdcName(udcName = "prd:attendance:approval", codePropName = "approvalResult")
    private String approvalResultName;


}

