package com.elitesland.tw.tw5.api.prd.my.vo;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.zhxu.bs.bean.DbIgnore;
import cn.zhxu.bs.bean.SearchBean;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsApprovalResVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 工时表
 *
 * @author duwh
 * @date 2022-12-09
 */
@SearchBean(
        tables = "t_timesheet tt ",
        where = "tt.delete_flag = 0",
        groupBy = ":groupBy:",
        autoMapTo = "tt"
)
@Data
public class TimesheetVO extends BaseViewModel implements Serializable {
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId = 0L;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;

    /**
     * 按周审批 id集合
     */
    @DbIgnore
    private String groupIds;
    /**
     * 填报用户id
     */
    @ApiModelProperty("填报用户id")
    private Long tsUserId;
    @UdcName(udcName = "USER", codePropName = "tsUserId")
    @DbIgnore
    private String tsUserIdName;
    /**
     * 填报Bu主键
     */
    @ApiModelProperty("填报Bu主键")
    private Long tsUserBuId;
    /**
     * 填报Bu名称
     */
    @UdcName(udcName = "BU", codePropName = "tsUserBuId")
    @DbIgnore
    private String tsUserBuName;
    /** 状态 */
    /**
     * see TimesheetStatus
     * 状态 - T_TIMESHEET.TS_STATUS
     * TSK:TIMESHEET_STATUS	新建	CREATE
     * TSK:TIMESHEET_STATUS	审批中	APPROVING
     * TSK:TIMESHEET_STATUS	已审批	APPROVED
     * TSK:TIMESHEET_STATUS	已结算	SETTLED
     * TSK:TIMESHEET_STATUS	已退回	REJECTED
     */
    @ApiModelProperty("工时状态")
    private String tsStatus;
    @UdcName(udcName = "prd:timesheet:status", codePropName = "tsStatus")
    @DbIgnore
    private String tsStatusDesc;
    /**
     * 类型
     */
    @ApiModelProperty("类型")
    private String type;

    /**
     * 审批用户id
     */
    @DbIgnore
    private Long oldApprUserId;
    /**
     * 审批用户id
     */
    @ApiModelProperty("审批用户id")
    private Long apprUserId;
    /**
     * 审批用户姓名
     */
    @UdcName(udcName = "USER", codePropName = "apprUserId")
    @DbIgnore
    private String apprUserIdName;
    /**
     * 客户经营计划主键
     */
    @ApiModelProperty("客户经营计划主键")
    private Long operPlanId;
    /**
     * 客户经营计划名称冗余
     */
    @ApiModelProperty("客户经营计划名称冗余")
    private String operPlanName;

    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 项目编号冗余
     */
    @ApiModelProperty("项目编号冗余")
    private String projNo;
    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projName;
    /**
     * 任务id
     */
    @ApiModelProperty("任务id")
    private Long taskId;

    /**
     * 任务包id
     */
    @ApiModelProperty("任务包id")
    private Long taskPackageId;
    /**
     * 任务包编号 冗余
     */
    @ApiModelProperty("任务包编号")
    private String taskPackageNo;
    /**
     * 任务包名称冗余
     */
    @ApiModelProperty("任务包名称冗余")
    private String taskPackageName;

    /**
     * 工时审批记录
     */
    @ApiModelProperty("工时审批记录")
    @DbIgnore
    List<TsApprovalResVO> tsApprovalResVOS;

    @ApiModelProperty("事由id")
    private Long reasonId;
    @ApiModelProperty("事由名称")
    private String reasonName;
    @ApiModelProperty("事由类型 PROJ_CONTRACT 合同项目 PROJ_OPPO 售前商机项目 PROJ_BU bu项目")
    private String reasonType;

    /**
     * 项目阶段id（活动阶段）
     */
    private Long stageId;
    /**
     * 项目阶段编号（冗余）
     */
    private String stageNo;
    /**
     * 项目阶段名称冗余
     */
    private String stageName;


    // public Long getTaskPackageId() {
    //     if (taskPackageId == null) {
    //         // if (StringUtils.hasText(type) && type.equals("DEV_OPS")) {
    //         //     return taskPackageId;
    //         // }
    //         if (projId != null && projId != 0) {
    //             return null;
    //         }
    //         taskPackageId = 0L;
    //     }
    //     return taskPackageId;
    // }

    // public String getTaskPackageName() {
    //     if (taskPackageId == null || (taskPackageId != null && taskPackageId.equals(0L))) {
    //         if (projId != null && projId != 0) {
    //             return null;
    //         }
    //         return "无任务";
    //     }
    //     return taskPackageName;
    // }

    // public Long getTaskId() {
    //     if (taskId == null) {
    //         if (StringUtils.hasText(type) && type.equals("DEV_OPS")) {
    //             return taskId;
    //         }
    //         if (projId != null && projId != 0) {
    //             return null;
    //         }
    //         taskId = 0L;
    //     }
    //     return taskId;
    // }

    // public String getTaskName() {
    //     if (StringUtils.hasText(type) && type.equals("DEV_OPS")) {
    //         return taskName;
    //     }
    //     if (taskId == null || (taskId != null && taskId.equals(0L))) {
    //         if (projId != null && projId != 0) {
    //             return null;
    //         }
    //         return "无任务";
    //     }
    //     return taskName;
    // }

    /**
     * 任务编号冗余
     */
    @ApiModelProperty("任务编号冗余")
    private String taskNo;
    /**
     * 任务名称冗余
     */
    @ApiModelProperty("任务名称冗余")
    private String taskName;
    /**
     * 任务包申请状态 see TimesheetStatus
     */
    private String taskApplyStatus;
    /**
     * 活动id
     */
    @ApiModelProperty("活动id")
    private Long actId;
    /**
     * 活动名称冗余
     */
    @ApiModelProperty("活动名称冗余")
    private String actName;
    /**
     * 活动编号冗余
     */
    private String actNo;
    /**
     * 当量
     */
    private BigDecimal eqva;
    /**
     * 11上午、22下午、33全天、44自定义
     */
    private String workType;
    /**
     * 工作日期
     */
    @ApiModelProperty("工作日期")
    private LocalDate workDate;
    /**
     * 工时
     */
    @ApiModelProperty("工时")
    private BigDecimal workHour;
    /**
     * 工作说明
     */
    @ApiModelProperty("工作说明")
    private String workDesc;
    /**
     * 本周开始日期
     */
    @ApiModelProperty("本周开始日期")
    private LocalDate weekStartDate;
    /**
     * 本周结束日期
     */
    @DbIgnore
    private LocalDate weekEndDate;

    public LocalDate getWeekEndDate() {
        if (null != weekStartDate) {
            return weekStartDate.plusDays(7);
        }
        return weekEndDate;
    }

    /**
     * 所在年周
     */
    @ApiModelProperty("所在年周")
    private Integer yearWeek;
    /**
     * 总计人天
     */
    @ApiModelProperty("总计人天")
    private BigDecimal totalManday;
    /**
     * 总计小时数
     */
    @ApiModelProperty("总计小时数")
    private BigDecimal totalWorkHour;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 任务标识
     */
    @ApiModelProperty("任务标识")
    private String tsTaskIden;
    @UdcName(udcName = "prd:timesheet:taskType", codePropName = "tsTaskIden")
    @DbIgnore
    private String tsTaskIdenDesc;
    /**
     * 活动标识
     */
    @ApiModelProperty("活动标识")
    private String tsActIden;
    @UdcName(udcName = "prd:timesheet:actType", codePropName = "tsActIden")
    @DbIgnore
    private String tsActIdenDesc;
    /**
     * 结算状态
     */
    private String settleStatus;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String apprResult;
    /** 是否加班、udc >> yesno */
    //private String workFlag;
    /** 可生成调休天数 */
    //private Float workDayOff;
    /** 相关加班安排id */
    //private Integer workRelId;
    /**
     * 可生成调休天数的状态
     */
    @ApiModelProperty("可生成调休天数的状态")
    private String workDayOffStatus;
    /**
     * 工作计划id
     */
    @ApiModelProperty("工作计划id")
    private Long workPlanId;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvalTime;
    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 最后提交时间
     */
    @ApiModelProperty("最后提交时间")
    private LocalDateTime lastSubmitTime;
    ///** 是否是系统自动生成，0：否，1：是 */
    //private Integer autoSaveFlag;
    ///** 请假流程覆盖已填写工时标记 默认0 已覆盖拆分 1 */
    //private Integer autoUpdateFlag;
    ///** 流程实例id */
    //private String procId;
    /**
     * 拓展1
     */
    private String ext1;
    /**
     * 拓展2
     */
    private String ext2;
    /**
     * 拓展3
     */
    private String ext3;
    /**
     * 出差类型 com.elitesland.tw.tw5.api.prd.my.vo.TimesheetSubsidySettingVO#subsidySelectTypeCode
     */
    private String ext4;
    @UdcName(udcName = "prd:timesheet:subsidy_select_type_code", codePropName = "ext4")
    @DbIgnore
    private String ext4Desc;
    /**
     * 拓展5
     */
    private String ext5;

    /**
     * 关联任务包的当量系数
     */
    @DbIgnore
    private BigDecimal eqvaRatio;

    /**
     * 工时占用的任务包的当量
     */
    @DbIgnore
    private BigDecimal eqvaTimeSheet;


    /**
     * 理论支出当量
     */
    @DbIgnore
    private BigDecimal theoryGetEqva;
    @DbIgnore
    private String baseCityId;
    @UdcName(udcName = "org:employee:serviceaddr", codePropName = "baseCityId")
    @DbIgnore
    private String baseCityName;
    /**
     * 产品编号
     */
    @DbIgnore
    private String productNo;
    /**
     * 费用承担buId
     */
    @DbIgnore
    private Long expenseBuId;
    @UdcName(udcName = "BU", codePropName = "expenseBuId")
    @DbIgnore
    private String expenseBuName;

    /**
     * 帮我吧工时
     */
    @ApiModelProperty("帮我吧工时")
    private BigDecimal bangwo8WorkHour;

    /**
     * 帮我吧工单链接
     */
    @ApiModelProperty("帮我吧工单链接")
    private String ticketUrl;


    /**
     * 帮我吧工时唯一标识
     */
    @ApiModelProperty("帮我吧工时唯一标识")
    private Long bangwo8No;

    /**
     * 地址
     */
    @ApiModelProperty("地址")
    private String location;

    /**
     * UT值
     */
    @ApiModelProperty("UT值")
    private Integer ut;

    /**
     * 补助金额
     */
    @ApiModelProperty("补助金额")
    private BigDecimal subsidyAmt;


    /**
     * 根据 当量系数 工时计算当量
     *
     * @return
     */
    public BigDecimal getEqvaTimeSheet() {
        if (this.eqvaTimeSheet != null) {
            return this.eqvaTimeSheet;
        }
        if (this.eqvaRatio != null && this.getWorkHour() != null) {
            return this.eqvaRatio.multiply(this.getWorkHour()).divide(BigDecimal.valueOf(8), 4, RoundingMode.DOWN);//向下取整数
        }
        return null;
    }

    @DbIgnore
    private String acceptMethod;// 任务包的验收方式

    /**
     * 人天  天数
     */
    @DbIgnore
    private BigDecimal showMandays;

    /**
     * 请假申请明细
     */
    private Long vacationApplyDetailId;


    @ApiModelProperty("是否可退回标记")
    private Boolean returnFlag;

    public BigDecimal getShowMandays() {
        if (workHour != null) {
            return workHour.divide(new BigDecimal("8"), 1, RoundingMode.UP);
        } else {
            return BigDecimal.ZERO;
        }
    }

    /**
     * 合同类型项目 工时占用的人天
     */
    @DbIgnore
    private BigDecimal projContractTimeSheet;

    public BigDecimal getProjContractTimeSheet() {
        if (this.projContractTimeSheet != null) {
            return this.projContractTimeSheet;
        }
        if (this.getWorkHour() != null) {
            return this.getWorkHour().divide(BigDecimal.valueOf(8), 4, RoundingMode.DOWN);//向下取整数
        }
        return null;
    }

    /**
     * 项目归属BU
     */
    @DbIgnore
    private String projectBuName;
    /**
     * 岗位名称
     */
    @DbIgnore
    private String jobsName;
    public void copy(TimesheetVO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }



}
