package com.elitesland.tw.tw5.api.prd.my.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class UserVacationApplyExcelVO implements Serializable {



    /**
     * 请假单号
     */
    @ExcelProperty(value = "请假单号", index = 0)
    private String applyNo;


    /**
     * 部门
     */
    @ExcelProperty(value = "BaseBu", index = 3)
    private String orgName;

    /**
     * 直属领导
     */
    @ExcelProperty(value = "直属领导", index = 4)
    private String parentUserName;

    /**
     * 假期类型
     * 公假	OFFICIAL	10
     * 产前检查假	PRENATAL_EXA	20
     * 哺乳假	BREASTFEED	30
     * 事假	PERSONAL	40
     * 病假	SICK	50
     * 婚假	MARRIAGE	60
     * 丧假	FUNERAL	70
     * 法定年休	ANNUAL	80
     * 福利年休	ANNUAL_W	81
     * 产假	MATERNITY	90
     */
    @ExcelProperty(value = "假期类型", index = 6)
    private String vacationTypeDesc;

    /**
     * 请假天数
     */
    @ExcelProperty(value = "请假天数", index = 7)
    private BigDecimal vacationDays;

    @ExcelProperty(value = "审批状态", index = 8)
    private String apprStatusDesc;

    /**
     * 申请人ID
     */
    @ExcelProperty(value = "申请人", index = 9)
    private String apprUserName;


    @ExcelProperty(value = "申请日期", index = 10)
    private String apprDateStr;




    @ExcelProperty(value = "休假日期", index = 5)
    private String detailVDateStr;


    @ApiModelProperty("员工编号")
    @ExcelProperty(value = "工号", index = 2)
    private String employeeNo;


    @ExcelProperty(value = "资源", index = 1)
    private String resource;

}
