package com.elitesland.tw.tw5.api.prd.partner.common.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 业务伙伴管理-银行账户/开票信息变更
 *
 * @author wangluyu
 * @date 2023-05-16
 */
@Getter
@Setter
public class BusinessPartnerChangePayload extends TwCommonPayload implements Serializable {

    @ApiModelProperty("变更单据ID")
    private Long businessKey;

    @ApiModelProperty("业务伙伴主档")
    private BusinessPartnerPayload businessPartnerPayload;

    @ApiModelProperty("银行账户信息")
    private List<BookAccountPayload> bookAccountPayloadList;

    @ApiModelProperty("开票信息")
    private List<BookInvoicePayload> bookInvoicePayloadList;
}


