package com.elitesland.tw.tw5.api.prd.partner.identity.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
 * 业务伙伴-客户信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Getter
@Setter
public class BusinessCustomerInfoQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;

    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private List<Long> idList;
    /**
     * 业务伙伴id business_partner.id 精确
     */
    @ApiModelProperty("业务伙伴id")
    private Long partnerId;

    /**
     * 客户编号
     */
    @ApiModelProperty("客户编号")
    private String customerNo;
    /**
     * 业务伙伴id business_partner.id 精确
     */
    @ApiModelProperty("业务伙伴id集合")
    private List<Long> partnerIdList;

    /**
     * 客户名称 精确
     */
    @ApiModelProperty("客户名称")
    private String partnerName;

    /**
     * 客户级别 udc[crm:customer_grade] 精确
     */
    @ApiModelProperty("客户级别 udc[crm:customer_grade]")
    private String customerGradle;

    /**
     * 客户状态 udc[CRM:BUSINESS_PARTNER:STATUS] 精确
     */
    @ApiModelProperty("客户状态 udc[CRM:BUSINESS_PARTNER:STATUS]")
    private String customerStatus;

    /**
     * 行业 udc[crm:leads_customer_industry] 精确
     */
    @ApiModelProperty("行业 udc[crm:leads_customer_industry]")
    private String partnerIndustry;

    /**
     * 客户来源 udc[crm:customer_source] 精确
     */
    @ApiModelProperty("客户来源 udc[crm:customer_source]")
    private String customerSource;

    /**
     * 客户阶段 udc[crm:customer_stage]
     */
    @ApiModelProperty("客户阶段 udc[crm:customer_stage]")
    private String customerStage;

    /**
     * 业务伙伴区域
     */
    @ApiModelProperty("业务伙伴区域 udc[crm:customer_region]")
    private String partnerRegion;

    /**
     * 客户经营状态 精确
     */
    @ApiModelProperty("客户经营状态")
    private String custOperStatus;

    /**
     * 扩展字段1 精确
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /**
     * 扩展字段2 精确
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3 精确
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字段4 精确
     */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /**
     * 扩展字段5 精确
     */
    @ApiModelProperty("扩展字段5")
    private String ext5;
    /**
     * 策略id business_strategy.id
     */
    @ApiModelProperty("策略id business_strategy.id")
    private Long strategyId;
    /**
     * 分数
     */
    @ApiModelProperty("分数")
    private BigDecimal score;
    /**
     * 待确认潜在客户
     */
    @ApiModelProperty("待确认潜在客户")
    private Boolean confirmFlag;

    /**
     * 销售资源id集合
     */
    private Set<Long> saleUserIds;


    /**
     * 商务负责人集合
     */
    private List<Long> businessUserIds;

    /**
     * 市场资源人员负责人集合
     */
    private List<Long> marketResUserId;

    /**
     * 需要权限
     */
    private Boolean permissionFlag = false;
    /**
     * 当前登录用户
     */
    private Long loginUserId;
    /**
     * 是否同步过JDE
     */
    @ApiModelProperty("是否同步过JDE")
    private Boolean syncJdeFlag;

    /**
     * 用户，用传入的用户替代当前登录人的权限
     */
    private Long queryUserId;

    /**
     * 性质 udc[crm:company_nature]
     */
    @ApiModelProperty("性质 udc[crm:company_nature]")
    private List<String> partnerNatureList;

    private String partnerNature;
}
