package com.elitesland.tw.tw5.api.prd.partner.strategy.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 分级策略-指标模型映射
 *
 * @author wangly
 * @date 2023-06-27
 */
@Getter
@Setter
public class BusinessStrategyIndexModelRefVO  extends BaseViewModel implements Serializable {

    /** 策略id business_strategy.id */
    @ApiModelProperty("策略id business_strategy.id")
    private Long strategyId;

    /** 指标编号 */
    @ApiModelProperty("指标编号")
    private String indexNo;

    /** 指标名称 */
    @ApiModelProperty("指标名称")
    private String indexName;

    /** 指标权重 */
    @ApiModelProperty("指标权重")
    private Integer indexWeight;

    /** 模型id business_strategy_model.id */
    @ApiModelProperty("模型id business_strategy_model.id")
    private Long modelId;

    /** 模型名称 */
    @ApiModelProperty("模型名称")
    private String modelName;

    /** 模型类型 udc[CRM:BUSINESS_STRATEGY_MODEL:TYPE] */
    @ApiModelProperty("模型类型 udc[CRM:BUSINESS_STRATEGY_MODEL:TYPE]")
    private String modelType;

    /** 是否标准模版 udc[CRM:BUSINESS_STRATEGY_MODEL:FLAG] */
    @ApiModelProperty("是否标准模版 udc[CRM:BUSINESS_STRATEGY_MODEL:FLAG]")
    private Boolean standaryFlag;

    /** 时间范围 udc[CRM:BUSINESS_STRATEGY_MODEL:DATE] */
    @ApiModelProperty("时间范围 udc[CRM:BUSINESS_STRATEGY_MODEL:DATE]")
    private String dateRange;

    /** R权重 */
    @ApiModelProperty("R权重")
    private BigDecimal RWeight;

    /** F权重 */
    @ApiModelProperty("F权重")
    private BigDecimal FWeight;

    /** M权重 */
    @ApiModelProperty("M权重")
    private BigDecimal MWeight;

    /** 模型指标集合 */
    @ApiModelProperty("模型指标集合")
    private List<BusinessModelIndexVO> businessModelIndexVOList;

}
