package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 项目结项
 *
 * @author xxb
 * @date 2023-11-27
 */
@Getter
@Setter
public class PmsProjectConclusionQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 异常结项标记 精确
     */
    @ApiModelProperty("异常结项标记")
    private Integer abnormalFlag;
    /**
     * 结项状态 精确
     */
    @ApiModelProperty("结项状态")
    private String conclusionStatus;
    /**
     * 审批状态 精确
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 流程实例ID 精确
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 提交资源userid 精确
     */
    @ApiModelProperty("提交资源userid")
    private Long applyUserId;
    /**
     * 申请日期 精确
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /**
     * 结项检查事项 精确
     */
    @ApiModelProperty("结项检查事项")
    private String conclusionCheckItems;
    /**
     * 项目id 精确
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 结项编号 模糊
     */
    @ApiModelProperty("结项编号")
    private String conclusionCode;


    @ApiModelProperty("开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate startDate;
    @ApiModelProperty("结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;

    @ApiModelProperty("项目状态")
    private String projStatus;
    @ApiModelProperty("项目编号")
    private String projNo;
    @ApiModelProperty("子合同编号")
    private String contractNo;
    @ApiModelProperty("项目经理资源id")
    private Long pmResId;
    @ApiModelProperty("交付BU_ID")
    private Long deliBuId;
    @ApiModelProperty("交付用户id")
    private Long deliUserId;
    @ApiModelProperty("销售负责人ID")
    private Long saleManUserId;
    /**
     * 需要权限
     */
    private Boolean permissionFlag = true;
}
