package com.elitesland.tw.tw5.api.prd.salecon.payload;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serializable;
import java.time.LocalDate;
import java.math.BigDecimal;

/**
 * invdtl
 *
 * @author zoey
 * @date 2023-08-02
 */
@Getter
@Setter
public class ConInvBatchInvdtlPayload extends TwCommonPayload  implements Serializable {
    /** 开票批次ID */
    @ApiModelProperty("开票批次ID")
    private Long invbatchId;
    /** 发票号 */
    @ApiModelProperty("发票号")
    private String invNo;
    /** 不含税金额 */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /** 税额 */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /** 发票金额 */
    @ApiModelProperty("发票金额")
    private BigDecimal invAmt;
    /** 发票状态 */
    @ApiModelProperty("发票状态")
    private String invStatus;
    /** 快递单号 */
    @ApiModelProperty("快递单号")
    private String deliveryNo;
    /** 快递日期 */
    @ApiModelProperty("快递日期")
    private LocalDate deliveryDate;
    /** 发票来源（null:手工插入） */
    @ApiModelProperty("发票来源（null:手工插入）")
    private String comeFrom;
    /** 发票下载地址（null:手工插入无地址） */
    @ApiModelProperty("发票下载地址（null:手工插入无地址）")
    private String downloadUrl;

    /** 实际开票日期 */
    @ApiModelProperty("实际开票日期")
    private LocalDate actualInvDate;

    /** 税率 */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
}
