package com.elitesland.tw.tw5.api.prd.salecon.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 收款计划确认单
 *
 * @author lemon
 * @date 2023-12-23
 */
@Getter
@Setter
public class ConReceivablePlanConfirmPayload extends TwCommonPayload implements Serializable {
    /**
     * 确认单编号
     */
    @ApiModelProperty("确认单编号")
    private String confirmNo;
    /**
     * 合同ID
     */
    @ApiModelProperty("合同ID")
    private Long contractId;
    /**
     * 关联收款计划ID
     */
    @ApiModelProperty("关联收款计划ID")
    private Long recePlanId;
    /**
     * 收款计划编号-收款号
     */
    @ApiModelProperty("收款计划编号-收款号")
    private String receNo;
    /**
     * 预付款计划-预计收款日期
     */
    @ApiModelProperty("预付款计划-预计收款日期")
    private LocalDate expectReceDate;
    /**
     * 提示类型备用
     */
    @ApiModelProperty("提示类型备用")
    private String tipsType;
    /**
     * 提示信息
     */
    @ApiModelProperty("提示信息")
    private String tips;
    /**
     * 销售负责人修改原因
     */
    @ApiModelProperty("销售负责人修改原因")
    private String salesRemark;
    /**
     * 项目经理修改原因
     */
    @ApiModelProperty("项目经理修改原因")
    private String pmRemark;
    /**
     * 预计收款日期调整
     */
    @ApiModelProperty("预计收款日期调整")
    private LocalDate adjExpectReceDate;
    /**
     * 由项目经理确认 0 不需要 1需要
     */
    @ApiModelProperty("由项目经理确认 0 不需要 1需要")
    private Integer pmConfirm;
    /**
     * 已付款由财务确认 0不需要 1需要
     */
    @ApiModelProperty("已付款由财务确认 0不需要 1需要")
    private Integer financeConfirm;
    /**
     * 是否发送催款函 0 不需要 1需要
     */
    @ApiModelProperty("是否发送催款函 0 不需要 1需要")
    private Integer sendPaymentRequest;
    /**
     * 预计收款日期确认无误？ 0 否 1是
     */
    @ApiModelProperty("预计收款日期确认无误？ 0 否 1是")
    private Integer receDateConfirm;
    /**
     * 申请状态
     */
    @ApiModelProperty("申请状态")
    private String applyStatus;
    /**
     * 申请人用户ID
     */
    @ApiModelProperty("申请人用户ID")
    private Long applyUserId;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

}
