package com.elitesland.tw.tw5.api.prd.salecon.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 收款计划确认单
 *
 * @author lemon
 * @date 2023-12-23
 */
@Getter
@Setter
public class ConReceivablePlanConfirmQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 确认单编号 精确
     */
    @ApiModelProperty("确认单编号")
    private String confirmNo;
    /**
     * 合同ID 精确
     */
    @ApiModelProperty("合同ID")
    private Long contractId;
    /**
     * 关联收款计划ID 精确
     */
    @ApiModelProperty("关联收款计划ID")
    private Long recePlanId;
    /**
     * 收款计划编号-收款号 精确
     */
    @ApiModelProperty("收款计划编号-收款号")
    private String receNo;
    /**
     * 预付款计划-预计收款日期 精确
     */
    @ApiModelProperty("预付款计划-预计收款日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate expectReceDate;
    /**
     * 提示类型备用 精确
     */
    @ApiModelProperty("提示类型备用")
    private String tipsType;
    /**
     * 提示信息 精确
     */
    @ApiModelProperty("提示信息")
    private String tips;
    /**
     * 销售负责人修改原因 精确
     */
    @ApiModelProperty("销售负责人修改原因")
    private String salesRemark;
    /**
     * 项目经理修改原因 精确
     */
    @ApiModelProperty("项目经理修改原因")
    private String pmRemark;
    /**
     * 预计收款日期调整 精确
     */
    @ApiModelProperty("预计收款日期调整")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate adjExpectReceDate;
    /**
     * 由项目经理确认 0 不需要 1需要 精确
     */
    @ApiModelProperty("由项目经理确认 0 不需要 1需要")
    private Integer pmConfirm;
    /**
     * 已付款由财务确认 0不需要 1需要 精确
     */
    @ApiModelProperty("已付款由财务确认 0不需要 1需要")
    private Integer financeConfirm;
    /**
     * 是否发送催款函 0 不需要 1需要 精确
     */
    @ApiModelProperty("是否发送催款函 0 不需要 1需要")
    private Integer sendPaymentRequest;
    /**
     * 预计收款日期确认无误？ 0 否 1是 精确
     */
    @ApiModelProperty("预计收款日期确认无误？ 0 否 1是")
    private Integer receDateConfirm;
    /**
     * 申请状态 精确
     */
    @ApiModelProperty("申请状态")
    private String applyStatus;
    /**
     * 申请人用户ID 精确
     */
    @ApiModelProperty("申请人用户ID")
    private Long applyUserId;
}
