package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemTagPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemTagQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemTagVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * service
 *
 * @author wangding
 */
public interface PrdSystemTagService {

    /**
     * 新增
     *
     * @param payload 单据数据
     */
    PrdSystemTagVO insert(PrdSystemTagPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     */
    Long update(PrdSystemTagPayload payload);

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return result
     */
    boolean delete(List<Long> keys);

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    boolean deleteSoft(List<Long> keys);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    PrdSystemTagVO queryByKey(Long key);

    /**
     * 清空系统选择项缓存
     *
     * @return result
     */
    void clearCache();

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<PrdSystemTagVO> paging(PrdSystemTagQuery query);

    /**
     * 列表查询
     *
     * @param query 查询参数
     * @return 结果
     */
    List<PrdSystemTagVO> queryList(PrdSystemTagQuery query);
}
