/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.api.prd.my.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.util.StringUtils;

@ExcelIgnoreUnannotated
public class PmsTimesheetExcel {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter FORMATTER_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    @ExcelProperty(index=0, value={"\u5de5\u4f5c\u65e5\u671f"})
    private String workDateStr;
    private String tsStatus;
    @ExcelProperty(index=1, value={"\u72b6\u6001"})
    @UdcName(udcName="prd:timesheet:status", codePropName="tsStatus")
    private String tsStatusDesc;
    private Long tsUserId;
    @ExcelProperty(index=2, value={"\u586b\u62a5\u4eba"})
    @UdcName(udcName="USER", codePropName="tsUserId")
    private String tsUserIdName;
    private Long tsUserBuId;
    @ExcelProperty(index=3, value={"\u586b\u62a5\u4eba\u90e8\u95e8"})
    @UdcName(udcName="BU", codePropName="tsUserBuId")
    private String tsUserBuName;
    @ExcelProperty(index=4, value={"\u5c97\u4f4d"})
    private String jobsName;
    @ApiModelProperty(value="\u4e8b\u7531\u540d\u79f0")
    @ExcelProperty(index=5, value={"\u9879\u76ee"})
    private String reasonName;
    @ExcelProperty(index=6, value={"\u9879\u76ee\u5f52\u5c5e\u90e8\u95e8"})
    private String projectBuName;
    @ExcelProperty(index=7, value={"\u9879\u76ee\u9636\u6bb5"})
    private String stageName;
    private String ext4;
    @ExcelProperty(index=8, value={"\u8865\u52a9\u7c7b\u578b"})
    @UdcName(udcName="prd:timesheet:subsidy_select_type_code", codePropName="ext4")
    private String ext4Desc;
    private BigDecimal workHour;
    @ExcelProperty(index=9, value={"\u5de5\u65f6"})
    private String workHourStr;
    @ApiModelProperty(value="\u8865\u52a9\u91d1\u989d")
    private BigDecimal subsidyAmt;
    @ExcelProperty(index=10, value={"\u8865\u52a9"})
    private String subsidyAmtStr;
    @ExcelProperty(index=11, value={"\u5de5\u4f5c\u65e5\u5fd7"})
    private String workDesc;
    @UdcName(udcName="USER", codePropName="apprUserId")
    @ExcelProperty(index=12, value={"\u5f53\u524d\u5ba1\u6279\u4eba"})
    private String apprUserIdName;
    private LocalDateTime submitTime;
    @ExcelProperty(index=13, value={"\u9996\u6b21\u63d0\u4ea4\u65f6\u95f4"})
    private String submitTimeStr;
    private LocalDateTime lastSubmitTime;
    @ExcelProperty(index=14, value={"\u5de5\u65f6\u66f4\u65b0\u65f6\u95f4"})
    private String lastSubmitTimeStr;
    private String baseCityId;
    @UdcName(udcName="org:employee:serviceaddr", codePropName="baseCityId")
    private String baseCityName;
    private Long taskId;
    private String taskNo;
    private String taskName;
    private String taskApplyStatus;
    private Long actId;
    private String actName;
    private String actNo;
    private BigDecimal eqva;
    private String workType;
    private LocalDate workDate;
    private LocalDate weekStartDate;
    private LocalDate weekEndDate;
    private Integer yearWeek;
    private BigDecimal totalManday;
    private BigDecimal totalWorkHour;
    private String apprStatus;
    private String tsTaskIden;
    private String tsActIden;
    @UdcName(udcName="prd:timesheet:notask", codePropName="tsActIden")
    private String tsActIdenDesc;
    private String settleStatus;
    private String apprResult;
    private String workDayOffStatus;
    private Long workPlanId;
    private String ext1;
    private String ext2;
    private String ext3;
    private String ext5;
    private BigDecimal eqvaRatio;
    private BigDecimal eqvaTimeSheet;
    private String acceptMethod;
    private LocalDateTime approvalTime;
    private String approvalTimeStr;
    private String remark;
    private Long operPlanId;
    private String operPlanName;
    private Long projId;
    private String projNo;
    private String projName;
    private Long taskPackageId;
    private String taskPackageNo;
    private String taskPackageName;
    private Long stageId;
    private String stageNo;
    private String type;
    private Long apprUserId;
    @ApiModelProperty(value="\u4e8b\u7531id")
    private Long reasonId;
    @ApiModelProperty(value="\u4e8b\u7531\u7c7b\u578b PROJ_CONTRACT \u5408\u540c\u9879\u76ee PROJ_OPPO \u552e\u524d\u5546\u673a\u9879\u76ee PROJ_BU bu\u9879\u76ee")
    private String reasonType;

    public String getWorkDateStr() {
        if (null != this.workDate) {
            return FORMATTER.format(this.workDate);
        }
        return this.workDateStr;
    }

    public String getWorkHourStr() {
        if (null != this.workHour) {
            return this.workHour.toString();
        }
        return this.workHourStr;
    }

    public String getSubsidyAmtStr() {
        if (null != this.subsidyAmt) {
            return this.subsidyAmt.toString();
        }
        return this.subsidyAmtStr;
    }

    public String getSubmitTimeStr() {
        if (null != this.submitTime) {
            return FORMATTER_TIME.format(this.submitTime);
        }
        return this.submitTimeStr;
    }

    public String getLastSubmitTimeStr() {
        if (null != this.lastSubmitTime) {
            return FORMATTER_TIME.format(this.lastSubmitTime);
        }
        return this.lastSubmitTimeStr;
    }

    public Long getTaskId() {
        if (this.taskId == null) {
            if (StringUtils.hasText((String)this.type) && this.type.equals("DEV_OPS")) {
                return this.taskId;
            }
            this.taskId = 0L;
        }
        return this.taskId;
    }

    public String getTaskName() {
        if (StringUtils.hasText((String)this.type) && this.type.equals("DEV_OPS")) {
            return this.taskName;
        }
        if (this.taskId == null || this.taskId != null && this.taskId.equals(0L)) {
            return "\u65e0\u4efb\u52a1";
        }
        return this.taskName;
    }

    public LocalDate getWeekEndDate() {
        if (null != this.weekStartDate) {
            return this.weekStartDate.plusDays(7L);
        }
        return this.weekEndDate;
    }

    public BigDecimal getEqvaTimeSheet() {
        if (this.eqvaTimeSheet != null) {
            return this.eqvaTimeSheet;
        }
        if (this.eqvaRatio != null && this.getWorkHour() != null) {
            return this.eqvaRatio.multiply(this.getWorkHour()).divide(BigDecimal.valueOf(8L), 2, RoundingMode.DOWN);
        }
        return null;
    }

    public String getApprovalTimeStr() {
        if (null != this.approvalTime) {
            return FORMATTER_TIME.format(this.approvalTime);
        }
        return this.approvalTimeStr;
    }

    public Long getTaskPackageId() {
        if (this.taskPackageId == null) {
            if (this.projId != null && this.projId != 0L) {
                return null;
            }
            this.taskPackageId = 0L;
        }
        return this.taskPackageId;
    }

    public String getTaskPackageName() {
        if (this.taskPackageId == null || this.taskPackageId != null && this.taskPackageId.equals(0L)) {
            if (this.projId != null && this.projId != 0L) {
                return null;
            }
            return "\u65e0\u4efb\u52a1";
        }
        return this.taskPackageName;
    }

    public String getTsStatus() {
        return this.tsStatus;
    }

    public String getTsStatusDesc() {
        return this.tsStatusDesc;
    }

    public Long getTsUserId() {
        return this.tsUserId;
    }

    public String getTsUserIdName() {
        return this.tsUserIdName;
    }

    public Long getTsUserBuId() {
        return this.tsUserBuId;
    }

    public String getTsUserBuName() {
        return this.tsUserBuName;
    }

    public String getJobsName() {
        return this.jobsName;
    }

    public String getReasonName() {
        return this.reasonName;
    }

    public String getProjectBuName() {
        return this.projectBuName;
    }

    public String getStageName() {
        return this.stageName;
    }

    public String getExt4() {
        return this.ext4;
    }

    public String getExt4Desc() {
        return this.ext4Desc;
    }

    public BigDecimal getWorkHour() {
        return this.workHour;
    }

    public BigDecimal getSubsidyAmt() {
        return this.subsidyAmt;
    }

    public String getWorkDesc() {
        return this.workDesc;
    }

    public String getApprUserIdName() {
        return this.apprUserIdName;
    }

    public LocalDateTime getSubmitTime() {
        return this.submitTime;
    }

    public LocalDateTime getLastSubmitTime() {
        return this.lastSubmitTime;
    }

    public String getBaseCityId() {
        return this.baseCityId;
    }

    public String getBaseCityName() {
        return this.baseCityName;
    }

    public String getTaskNo() {
        return this.taskNo;
    }

    public String getTaskApplyStatus() {
        return this.taskApplyStatus;
    }

    public Long getActId() {
        return this.actId;
    }

    public String getActName() {
        return this.actName;
    }

    public String getActNo() {
        return this.actNo;
    }

    public BigDecimal getEqva() {
        return this.eqva;
    }

    public String getWorkType() {
        return this.workType;
    }

    public LocalDate getWorkDate() {
        return this.workDate;
    }

    public LocalDate getWeekStartDate() {
        return this.weekStartDate;
    }

    public Integer getYearWeek() {
        return this.yearWeek;
    }

    public BigDecimal getTotalManday() {
        return this.totalManday;
    }

    public BigDecimal getTotalWorkHour() {
        return this.totalWorkHour;
    }

    public String getApprStatus() {
        return this.apprStatus;
    }

    public String getTsTaskIden() {
        return this.tsTaskIden;
    }

    public String getTsActIden() {
        return this.tsActIden;
    }

    public String getTsActIdenDesc() {
        return this.tsActIdenDesc;
    }

    public String getSettleStatus() {
        return this.settleStatus;
    }

    public String getApprResult() {
        return this.apprResult;
    }

    public String getWorkDayOffStatus() {
        return this.workDayOffStatus;
    }

    public Long getWorkPlanId() {
        return this.workPlanId;
    }

    public String getExt1() {
        return this.ext1;
    }

    public String getExt2() {
        return this.ext2;
    }

    public String getExt3() {
        return this.ext3;
    }

    public String getExt5() {
        return this.ext5;
    }

    public BigDecimal getEqvaRatio() {
        return this.eqvaRatio;
    }

    public String getAcceptMethod() {
        return this.acceptMethod;
    }

    public LocalDateTime getApprovalTime() {
        return this.approvalTime;
    }

    public String getRemark() {
        return this.remark;
    }

    public Long getOperPlanId() {
        return this.operPlanId;
    }

    public String getOperPlanName() {
        return this.operPlanName;
    }

    public Long getProjId() {
        return this.projId;
    }

    public String getProjNo() {
        return this.projNo;
    }

    public String getProjName() {
        return this.projName;
    }

    public String getTaskPackageNo() {
        return this.taskPackageNo;
    }

    public Long getStageId() {
        return this.stageId;
    }

    public String getStageNo() {
        return this.stageNo;
    }

    public String getType() {
        return this.type;
    }

    public Long getApprUserId() {
        return this.apprUserId;
    }

    public Long getReasonId() {
        return this.reasonId;
    }

    public String getReasonType() {
        return this.reasonType;
    }

    public void setWorkDateStr(String workDateStr) {
        this.workDateStr = workDateStr;
    }

    public void setTsStatus(String tsStatus) {
        this.tsStatus = tsStatus;
    }

    public void setTsStatusDesc(String tsStatusDesc) {
        this.tsStatusDesc = tsStatusDesc;
    }

    public void setTsUserId(Long tsUserId) {
        this.tsUserId = tsUserId;
    }

    public void setTsUserIdName(String tsUserIdName) {
        this.tsUserIdName = tsUserIdName;
    }

    public void setTsUserBuId(Long tsUserBuId) {
        this.tsUserBuId = tsUserBuId;
    }

    public void setTsUserBuName(String tsUserBuName) {
        this.tsUserBuName = tsUserBuName;
    }

    public void setJobsName(String jobsName) {
        this.jobsName = jobsName;
    }

    public void setReasonName(String reasonName) {
        this.reasonName = reasonName;
    }

    public void setProjectBuName(String projectBuName) {
        this.projectBuName = projectBuName;
    }

    public void setStageName(String stageName) {
        this.stageName = stageName;
    }

    public void setExt4(String ext4) {
        this.ext4 = ext4;
    }

    public void setExt4Desc(String ext4Desc) {
        this.ext4Desc = ext4Desc;
    }

    public void setWorkHour(BigDecimal workHour) {
        this.workHour = workHour;
    }

    public void setWorkHourStr(String workHourStr) {
        this.workHourStr = workHourStr;
    }

    public void setSubsidyAmt(BigDecimal subsidyAmt) {
        this.subsidyAmt = subsidyAmt;
    }

    public void setSubsidyAmtStr(String subsidyAmtStr) {
        this.subsidyAmtStr = subsidyAmtStr;
    }

    public void setWorkDesc(String workDesc) {
        this.workDesc = workDesc;
    }

    public void setApprUserIdName(String apprUserIdName) {
        this.apprUserIdName = apprUserIdName;
    }

    public void setSubmitTime(LocalDateTime submitTime) {
        this.submitTime = submitTime;
    }

    public void setSubmitTimeStr(String submitTimeStr) {
        this.submitTimeStr = submitTimeStr;
    }

    public void setLastSubmitTime(LocalDateTime lastSubmitTime) {
        this.lastSubmitTime = lastSubmitTime;
    }

    public void setLastSubmitTimeStr(String lastSubmitTimeStr) {
        this.lastSubmitTimeStr = lastSubmitTimeStr;
    }

    public void setBaseCityId(String baseCityId) {
        this.baseCityId = baseCityId;
    }

    public void setBaseCityName(String baseCityName) {
        this.baseCityName = baseCityName;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public void setTaskNo(String taskNo) {
        this.taskNo = taskNo;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setTaskApplyStatus(String taskApplyStatus) {
        this.taskApplyStatus = taskApplyStatus;
    }

    public void setActId(Long actId) {
        this.actId = actId;
    }

    public void setActName(String actName) {
        this.actName = actName;
    }

    public void setActNo(String actNo) {
        this.actNo = actNo;
    }

    public void setEqva(BigDecimal eqva) {
        this.eqva = eqva;
    }

    public void setWorkType(String workType) {
        this.workType = workType;
    }

    public void setWorkDate(LocalDate workDate) {
        this.workDate = workDate;
    }

    public void setWeekStartDate(LocalDate weekStartDate) {
        this.weekStartDate = weekStartDate;
    }

    public void setWeekEndDate(LocalDate weekEndDate) {
        this.weekEndDate = weekEndDate;
    }

    public void setYearWeek(Integer yearWeek) {
        this.yearWeek = yearWeek;
    }

    public void setTotalManday(BigDecimal totalManday) {
        this.totalManday = totalManday;
    }

    public void setTotalWorkHour(BigDecimal totalWorkHour) {
        this.totalWorkHour = totalWorkHour;
    }

    public void setApprStatus(String apprStatus) {
        this.apprStatus = apprStatus;
    }

    public void setTsTaskIden(String tsTaskIden) {
        this.tsTaskIden = tsTaskIden;
    }

    public void setTsActIden(String tsActIden) {
        this.tsActIden = tsActIden;
    }

    public void setTsActIdenDesc(String tsActIdenDesc) {
        this.tsActIdenDesc = tsActIdenDesc;
    }

    public void setSettleStatus(String settleStatus) {
        this.settleStatus = settleStatus;
    }

    public void setApprResult(String apprResult) {
        this.apprResult = apprResult;
    }

    public void setWorkDayOffStatus(String workDayOffStatus) {
        this.workDayOffStatus = workDayOffStatus;
    }

    public void setWorkPlanId(Long workPlanId) {
        this.workPlanId = workPlanId;
    }

    public void setExt1(String ext1) {
        this.ext1 = ext1;
    }

    public void setExt2(String ext2) {
        this.ext2 = ext2;
    }

    public void setExt3(String ext3) {
        this.ext3 = ext3;
    }

    public void setExt5(String ext5) {
        this.ext5 = ext5;
    }

    public void setEqvaRatio(BigDecimal eqvaRatio) {
        this.eqvaRatio = eqvaRatio;
    }

    public void setEqvaTimeSheet(BigDecimal eqvaTimeSheet) {
        this.eqvaTimeSheet = eqvaTimeSheet;
    }

    public void setAcceptMethod(String acceptMethod) {
        this.acceptMethod = acceptMethod;
    }

    public void setApprovalTime(LocalDateTime approvalTime) {
        this.approvalTime = approvalTime;
    }

    public void setApprovalTimeStr(String approvalTimeStr) {
        this.approvalTimeStr = approvalTimeStr;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setOperPlanId(Long operPlanId) {
        this.operPlanId = operPlanId;
    }

    public void setOperPlanName(String operPlanName) {
        this.operPlanName = operPlanName;
    }

    public void setProjId(Long projId) {
        this.projId = projId;
    }

    public void setProjNo(String projNo) {
        this.projNo = projNo;
    }

    public void setProjName(String projName) {
        this.projName = projName;
    }

    public void setTaskPackageId(Long taskPackageId) {
        this.taskPackageId = taskPackageId;
    }

    public void setTaskPackageNo(String taskPackageNo) {
        this.taskPackageNo = taskPackageNo;
    }

    public void setTaskPackageName(String taskPackageName) {
        this.taskPackageName = taskPackageName;
    }

    public void setStageId(Long stageId) {
        this.stageId = stageId;
    }

    public void setStageNo(String stageNo) {
        this.stageNo = stageNo;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setApprUserId(Long apprUserId) {
        this.apprUserId = apprUserId;
    }

    public void setReasonId(Long reasonId) {
        this.reasonId = reasonId;
    }

    public void setReasonType(String reasonType) {
        this.reasonType = reasonType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PmsTimesheetExcel)) {
            return false;
        }
        PmsTimesheetExcel other = (PmsTimesheetExcel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$tsUserId = this.getTsUserId();
        Long other$tsUserId = other.getTsUserId();
        if (this$tsUserId == null ? other$tsUserId != null : !((Object)this$tsUserId).equals(other$tsUserId)) {
            return false;
        }
        Long this$tsUserBuId = this.getTsUserBuId();
        Long other$tsUserBuId = other.getTsUserBuId();
        if (this$tsUserBuId == null ? other$tsUserBuId != null : !((Object)this$tsUserBuId).equals(other$tsUserBuId)) {
            return false;
        }
        Long this$taskId = this.getTaskId();
        Long other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId)) {
            return false;
        }
        Long this$actId = this.getActId();
        Long other$actId = other.getActId();
        if (this$actId == null ? other$actId != null : !((Object)this$actId).equals(other$actId)) {
            return false;
        }
        Integer this$yearWeek = this.getYearWeek();
        Integer other$yearWeek = other.getYearWeek();
        if (this$yearWeek == null ? other$yearWeek != null : !((Object)this$yearWeek).equals(other$yearWeek)) {
            return false;
        }
        Long this$workPlanId = this.getWorkPlanId();
        Long other$workPlanId = other.getWorkPlanId();
        if (this$workPlanId == null ? other$workPlanId != null : !((Object)this$workPlanId).equals(other$workPlanId)) {
            return false;
        }
        Long this$operPlanId = this.getOperPlanId();
        Long other$operPlanId = other.getOperPlanId();
        if (this$operPlanId == null ? other$operPlanId != null : !((Object)this$operPlanId).equals(other$operPlanId)) {
            return false;
        }
        Long this$projId = this.getProjId();
        Long other$projId = other.getProjId();
        if (this$projId == null ? other$projId != null : !((Object)this$projId).equals(other$projId)) {
            return false;
        }
        Long this$taskPackageId = this.getTaskPackageId();
        Long other$taskPackageId = other.getTaskPackageId();
        if (this$taskPackageId == null ? other$taskPackageId != null : !((Object)this$taskPackageId).equals(other$taskPackageId)) {
            return false;
        }
        Long this$stageId = this.getStageId();
        Long other$stageId = other.getStageId();
        if (this$stageId == null ? other$stageId != null : !((Object)this$stageId).equals(other$stageId)) {
            return false;
        }
        Long this$apprUserId = this.getApprUserId();
        Long other$apprUserId = other.getApprUserId();
        if (this$apprUserId == null ? other$apprUserId != null : !((Object)this$apprUserId).equals(other$apprUserId)) {
            return false;
        }
        Long this$reasonId = this.getReasonId();
        Long other$reasonId = other.getReasonId();
        if (this$reasonId == null ? other$reasonId != null : !((Object)this$reasonId).equals(other$reasonId)) {
            return false;
        }
        String this$workDateStr = this.getWorkDateStr();
        String other$workDateStr = other.getWorkDateStr();
        if (this$workDateStr == null ? other$workDateStr != null : !this$workDateStr.equals(other$workDateStr)) {
            return false;
        }
        String this$tsStatus = this.getTsStatus();
        String other$tsStatus = other.getTsStatus();
        if (this$tsStatus == null ? other$tsStatus != null : !this$tsStatus.equals(other$tsStatus)) {
            return false;
        }
        String this$tsStatusDesc = this.getTsStatusDesc();
        String other$tsStatusDesc = other.getTsStatusDesc();
        if (this$tsStatusDesc == null ? other$tsStatusDesc != null : !this$tsStatusDesc.equals(other$tsStatusDesc)) {
            return false;
        }
        String this$tsUserIdName = this.getTsUserIdName();
        String other$tsUserIdName = other.getTsUserIdName();
        if (this$tsUserIdName == null ? other$tsUserIdName != null : !this$tsUserIdName.equals(other$tsUserIdName)) {
            return false;
        }
        String this$tsUserBuName = this.getTsUserBuName();
        String other$tsUserBuName = other.getTsUserBuName();
        if (this$tsUserBuName == null ? other$tsUserBuName != null : !this$tsUserBuName.equals(other$tsUserBuName)) {
            return false;
        }
        String this$jobsName = this.getJobsName();
        String other$jobsName = other.getJobsName();
        if (this$jobsName == null ? other$jobsName != null : !this$jobsName.equals(other$jobsName)) {
            return false;
        }
        String this$reasonName = this.getReasonName();
        String other$reasonName = other.getReasonName();
        if (this$reasonName == null ? other$reasonName != null : !this$reasonName.equals(other$reasonName)) {
            return false;
        }
        String this$projectBuName = this.getProjectBuName();
        String other$projectBuName = other.getProjectBuName();
        if (this$projectBuName == null ? other$projectBuName != null : !this$projectBuName.equals(other$projectBuName)) {
            return false;
        }
        String this$stageName = this.getStageName();
        String other$stageName = other.getStageName();
        if (this$stageName == null ? other$stageName != null : !this$stageName.equals(other$stageName)) {
            return false;
        }
        String this$ext4 = this.getExt4();
        String other$ext4 = other.getExt4();
        if (this$ext4 == null ? other$ext4 != null : !this$ext4.equals(other$ext4)) {
            return false;
        }
        String this$ext4Desc = this.getExt4Desc();
        String other$ext4Desc = other.getExt4Desc();
        if (this$ext4Desc == null ? other$ext4Desc != null : !this$ext4Desc.equals(other$ext4Desc)) {
            return false;
        }
        BigDecimal this$workHour = this.getWorkHour();
        BigDecimal other$workHour = other.getWorkHour();
        if (this$workHour == null ? other$workHour != null : !((Object)this$workHour).equals(other$workHour)) {
            return false;
        }
        String this$workHourStr = this.getWorkHourStr();
        String other$workHourStr = other.getWorkHourStr();
        if (this$workHourStr == null ? other$workHourStr != null : !this$workHourStr.equals(other$workHourStr)) {
            return false;
        }
        BigDecimal this$subsidyAmt = this.getSubsidyAmt();
        BigDecimal other$subsidyAmt = other.getSubsidyAmt();
        if (this$subsidyAmt == null ? other$subsidyAmt != null : !((Object)this$subsidyAmt).equals(other$subsidyAmt)) {
            return false;
        }
        String this$subsidyAmtStr = this.getSubsidyAmtStr();
        String other$subsidyAmtStr = other.getSubsidyAmtStr();
        if (this$subsidyAmtStr == null ? other$subsidyAmtStr != null : !this$subsidyAmtStr.equals(other$subsidyAmtStr)) {
            return false;
        }
        String this$workDesc = this.getWorkDesc();
        String other$workDesc = other.getWorkDesc();
        if (this$workDesc == null ? other$workDesc != null : !this$workDesc.equals(other$workDesc)) {
            return false;
        }
        String this$apprUserIdName = this.getApprUserIdName();
        String other$apprUserIdName = other.getApprUserIdName();
        if (this$apprUserIdName == null ? other$apprUserIdName != null : !this$apprUserIdName.equals(other$apprUserIdName)) {
            return false;
        }
        LocalDateTime this$submitTime = this.getSubmitTime();
        LocalDateTime other$submitTime = other.getSubmitTime();
        if (this$submitTime == null ? other$submitTime != null : !((Object)this$submitTime).equals(other$submitTime)) {
            return false;
        }
        String this$submitTimeStr = this.getSubmitTimeStr();
        String other$submitTimeStr = other.getSubmitTimeStr();
        if (this$submitTimeStr == null ? other$submitTimeStr != null : !this$submitTimeStr.equals(other$submitTimeStr)) {
            return false;
        }
        LocalDateTime this$lastSubmitTime = this.getLastSubmitTime();
        LocalDateTime other$lastSubmitTime = other.getLastSubmitTime();
        if (this$lastSubmitTime == null ? other$lastSubmitTime != null : !((Object)this$lastSubmitTime).equals(other$lastSubmitTime)) {
            return false;
        }
        String this$lastSubmitTimeStr = this.getLastSubmitTimeStr();
        String other$lastSubmitTimeStr = other.getLastSubmitTimeStr();
        if (this$lastSubmitTimeStr == null ? other$lastSubmitTimeStr != null : !this$lastSubmitTimeStr.equals(other$lastSubmitTimeStr)) {
            return false;
        }
        String this$baseCityId = this.getBaseCityId();
        String other$baseCityId = other.getBaseCityId();
        if (this$baseCityId == null ? other$baseCityId != null : !this$baseCityId.equals(other$baseCityId)) {
            return false;
        }
        String this$baseCityName = this.getBaseCityName();
        String other$baseCityName = other.getBaseCityName();
        if (this$baseCityName == null ? other$baseCityName != null : !this$baseCityName.equals(other$baseCityName)) {
            return false;
        }
        String this$taskNo = this.getTaskNo();
        String other$taskNo = other.getTaskNo();
        if (this$taskNo == null ? other$taskNo != null : !this$taskNo.equals(other$taskNo)) {
            return false;
        }
        String this$taskName = this.getTaskName();
        String other$taskName = other.getTaskName();
        if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
            return false;
        }
        String this$taskApplyStatus = this.getTaskApplyStatus();
        String other$taskApplyStatus = other.getTaskApplyStatus();
        if (this$taskApplyStatus == null ? other$taskApplyStatus != null : !this$taskApplyStatus.equals(other$taskApplyStatus)) {
            return false;
        }
        String this$actName = this.getActName();
        String other$actName = other.getActName();
        if (this$actName == null ? other$actName != null : !this$actName.equals(other$actName)) {
            return false;
        }
        String this$actNo = this.getActNo();
        String other$actNo = other.getActNo();
        if (this$actNo == null ? other$actNo != null : !this$actNo.equals(other$actNo)) {
            return false;
        }
        BigDecimal this$eqva = this.getEqva();
        BigDecimal other$eqva = other.getEqva();
        if (this$eqva == null ? other$eqva != null : !((Object)this$eqva).equals(other$eqva)) {
            return false;
        }
        String this$workType = this.getWorkType();
        String other$workType = other.getWorkType();
        if (this$workType == null ? other$workType != null : !this$workType.equals(other$workType)) {
            return false;
        }
        LocalDate this$workDate = this.getWorkDate();
        LocalDate other$workDate = other.getWorkDate();
        if (this$workDate == null ? other$workDate != null : !((Object)this$workDate).equals(other$workDate)) {
            return false;
        }
        LocalDate this$weekStartDate = this.getWeekStartDate();
        LocalDate other$weekStartDate = other.getWeekStartDate();
        if (this$weekStartDate == null ? other$weekStartDate != null : !((Object)this$weekStartDate).equals(other$weekStartDate)) {
            return false;
        }
        LocalDate this$weekEndDate = this.getWeekEndDate();
        LocalDate other$weekEndDate = other.getWeekEndDate();
        if (this$weekEndDate == null ? other$weekEndDate != null : !((Object)this$weekEndDate).equals(other$weekEndDate)) {
            return false;
        }
        BigDecimal this$totalManday = this.getTotalManday();
        BigDecimal other$totalManday = other.getTotalManday();
        if (this$totalManday == null ? other$totalManday != null : !((Object)this$totalManday).equals(other$totalManday)) {
            return false;
        }
        BigDecimal this$totalWorkHour = this.getTotalWorkHour();
        BigDecimal other$totalWorkHour = other.getTotalWorkHour();
        if (this$totalWorkHour == null ? other$totalWorkHour != null : !((Object)this$totalWorkHour).equals(other$totalWorkHour)) {
            return false;
        }
        String this$apprStatus = this.getApprStatus();
        String other$apprStatus = other.getApprStatus();
        if (this$apprStatus == null ? other$apprStatus != null : !this$apprStatus.equals(other$apprStatus)) {
            return false;
        }
        String this$tsTaskIden = this.getTsTaskIden();
        String other$tsTaskIden = other.getTsTaskIden();
        if (this$tsTaskIden == null ? other$tsTaskIden != null : !this$tsTaskIden.equals(other$tsTaskIden)) {
            return false;
        }
        String this$tsActIden = this.getTsActIden();
        String other$tsActIden = other.getTsActIden();
        if (this$tsActIden == null ? other$tsActIden != null : !this$tsActIden.equals(other$tsActIden)) {
            return false;
        }
        String this$tsActIdenDesc = this.getTsActIdenDesc();
        String other$tsActIdenDesc = other.getTsActIdenDesc();
        if (this$tsActIdenDesc == null ? other$tsActIdenDesc != null : !this$tsActIdenDesc.equals(other$tsActIdenDesc)) {
            return false;
        }
        String this$settleStatus = this.getSettleStatus();
        String other$settleStatus = other.getSettleStatus();
        if (this$settleStatus == null ? other$settleStatus != null : !this$settleStatus.equals(other$settleStatus)) {
            return false;
        }
        String this$apprResult = this.getApprResult();
        String other$apprResult = other.getApprResult();
        if (this$apprResult == null ? other$apprResult != null : !this$apprResult.equals(other$apprResult)) {
            return false;
        }
        String this$workDayOffStatus = this.getWorkDayOffStatus();
        String other$workDayOffStatus = other.getWorkDayOffStatus();
        if (this$workDayOffStatus == null ? other$workDayOffStatus != null : !this$workDayOffStatus.equals(other$workDayOffStatus)) {
            return false;
        }
        String this$ext1 = this.getExt1();
        String other$ext1 = other.getExt1();
        if (this$ext1 == null ? other$ext1 != null : !this$ext1.equals(other$ext1)) {
            return false;
        }
        String this$ext2 = this.getExt2();
        String other$ext2 = other.getExt2();
        if (this$ext2 == null ? other$ext2 != null : !this$ext2.equals(other$ext2)) {
            return false;
        }
        String this$ext3 = this.getExt3();
        String other$ext3 = other.getExt3();
        if (this$ext3 == null ? other$ext3 != null : !this$ext3.equals(other$ext3)) {
            return false;
        }
        String this$ext5 = this.getExt5();
        String other$ext5 = other.getExt5();
        if (this$ext5 == null ? other$ext5 != null : !this$ext5.equals(other$ext5)) {
            return false;
        }
        BigDecimal this$eqvaRatio = this.getEqvaRatio();
        BigDecimal other$eqvaRatio = other.getEqvaRatio();
        if (this$eqvaRatio == null ? other$eqvaRatio != null : !((Object)this$eqvaRatio).equals(other$eqvaRatio)) {
            return false;
        }
        BigDecimal this$eqvaTimeSheet = this.getEqvaTimeSheet();
        BigDecimal other$eqvaTimeSheet = other.getEqvaTimeSheet();
        if (this$eqvaTimeSheet == null ? other$eqvaTimeSheet != null : !((Object)this$eqvaTimeSheet).equals(other$eqvaTimeSheet)) {
            return false;
        }
        String this$acceptMethod = this.getAcceptMethod();
        String other$acceptMethod = other.getAcceptMethod();
        if (this$acceptMethod == null ? other$acceptMethod != null : !this$acceptMethod.equals(other$acceptMethod)) {
            return false;
        }
        LocalDateTime this$approvalTime = this.getApprovalTime();
        LocalDateTime other$approvalTime = other.getApprovalTime();
        if (this$approvalTime == null ? other$approvalTime != null : !((Object)this$approvalTime).equals(other$approvalTime)) {
            return false;
        }
        String this$approvalTimeStr = this.getApprovalTimeStr();
        String other$approvalTimeStr = other.getApprovalTimeStr();
        if (this$approvalTimeStr == null ? other$approvalTimeStr != null : !this$approvalTimeStr.equals(other$approvalTimeStr)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        String this$operPlanName = this.getOperPlanName();
        String other$operPlanName = other.getOperPlanName();
        if (this$operPlanName == null ? other$operPlanName != null : !this$operPlanName.equals(other$operPlanName)) {
            return false;
        }
        String this$projNo = this.getProjNo();
        String other$projNo = other.getProjNo();
        if (this$projNo == null ? other$projNo != null : !this$projNo.equals(other$projNo)) {
            return false;
        }
        String this$projName = this.getProjName();
        String other$projName = other.getProjName();
        if (this$projName == null ? other$projName != null : !this$projName.equals(other$projName)) {
            return false;
        }
        String this$taskPackageNo = this.getTaskPackageNo();
        String other$taskPackageNo = other.getTaskPackageNo();
        if (this$taskPackageNo == null ? other$taskPackageNo != null : !this$taskPackageNo.equals(other$taskPackageNo)) {
            return false;
        }
        String this$taskPackageName = this.getTaskPackageName();
        String other$taskPackageName = other.getTaskPackageName();
        if (this$taskPackageName == null ? other$taskPackageName != null : !this$taskPackageName.equals(other$taskPackageName)) {
            return false;
        }
        String this$stageNo = this.getStageNo();
        String other$stageNo = other.getStageNo();
        if (this$stageNo == null ? other$stageNo != null : !this$stageNo.equals(other$stageNo)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$reasonType = this.getReasonType();
        String other$reasonType = other.getReasonType();
        return !(this$reasonType == null ? other$reasonType != null : !this$reasonType.equals(other$reasonType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PmsTimesheetExcel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $tsUserId = this.getTsUserId();
        result = result * 59 + ($tsUserId == null ? 43 : ((Object)$tsUserId).hashCode());
        Long $tsUserBuId = this.getTsUserBuId();
        result = result * 59 + ($tsUserBuId == null ? 43 : ((Object)$tsUserBuId).hashCode());
        Long $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        Long $actId = this.getActId();
        result = result * 59 + ($actId == null ? 43 : ((Object)$actId).hashCode());
        Integer $yearWeek = this.getYearWeek();
        result = result * 59 + ($yearWeek == null ? 43 : ((Object)$yearWeek).hashCode());
        Long $workPlanId = this.getWorkPlanId();
        result = result * 59 + ($workPlanId == null ? 43 : ((Object)$workPlanId).hashCode());
        Long $operPlanId = this.getOperPlanId();
        result = result * 59 + ($operPlanId == null ? 43 : ((Object)$operPlanId).hashCode());
        Long $projId = this.getProjId();
        result = result * 59 + ($projId == null ? 43 : ((Object)$projId).hashCode());
        Long $taskPackageId = this.getTaskPackageId();
        result = result * 59 + ($taskPackageId == null ? 43 : ((Object)$taskPackageId).hashCode());
        Long $stageId = this.getStageId();
        result = result * 59 + ($stageId == null ? 43 : ((Object)$stageId).hashCode());
        Long $apprUserId = this.getApprUserId();
        result = result * 59 + ($apprUserId == null ? 43 : ((Object)$apprUserId).hashCode());
        Long $reasonId = this.getReasonId();
        result = result * 59 + ($reasonId == null ? 43 : ((Object)$reasonId).hashCode());
        String $workDateStr = this.getWorkDateStr();
        result = result * 59 + ($workDateStr == null ? 43 : $workDateStr.hashCode());
        String $tsStatus = this.getTsStatus();
        result = result * 59 + ($tsStatus == null ? 43 : $tsStatus.hashCode());
        String $tsStatusDesc = this.getTsStatusDesc();
        result = result * 59 + ($tsStatusDesc == null ? 43 : $tsStatusDesc.hashCode());
        String $tsUserIdName = this.getTsUserIdName();
        result = result * 59 + ($tsUserIdName == null ? 43 : $tsUserIdName.hashCode());
        String $tsUserBuName = this.getTsUserBuName();
        result = result * 59 + ($tsUserBuName == null ? 43 : $tsUserBuName.hashCode());
        String $jobsName = this.getJobsName();
        result = result * 59 + ($jobsName == null ? 43 : $jobsName.hashCode());
        String $reasonName = this.getReasonName();
        result = result * 59 + ($reasonName == null ? 43 : $reasonName.hashCode());
        String $projectBuName = this.getProjectBuName();
        result = result * 59 + ($projectBuName == null ? 43 : $projectBuName.hashCode());
        String $stageName = this.getStageName();
        result = result * 59 + ($stageName == null ? 43 : $stageName.hashCode());
        String $ext4 = this.getExt4();
        result = result * 59 + ($ext4 == null ? 43 : $ext4.hashCode());
        String $ext4Desc = this.getExt4Desc();
        result = result * 59 + ($ext4Desc == null ? 43 : $ext4Desc.hashCode());
        BigDecimal $workHour = this.getWorkHour();
        result = result * 59 + ($workHour == null ? 43 : ((Object)$workHour).hashCode());
        String $workHourStr = this.getWorkHourStr();
        result = result * 59 + ($workHourStr == null ? 43 : $workHourStr.hashCode());
        BigDecimal $subsidyAmt = this.getSubsidyAmt();
        result = result * 59 + ($subsidyAmt == null ? 43 : ((Object)$subsidyAmt).hashCode());
        String $subsidyAmtStr = this.getSubsidyAmtStr();
        result = result * 59 + ($subsidyAmtStr == null ? 43 : $subsidyAmtStr.hashCode());
        String $workDesc = this.getWorkDesc();
        result = result * 59 + ($workDesc == null ? 43 : $workDesc.hashCode());
        String $apprUserIdName = this.getApprUserIdName();
        result = result * 59 + ($apprUserIdName == null ? 43 : $apprUserIdName.hashCode());
        LocalDateTime $submitTime = this.getSubmitTime();
        result = result * 59 + ($submitTime == null ? 43 : ((Object)$submitTime).hashCode());
        String $submitTimeStr = this.getSubmitTimeStr();
        result = result * 59 + ($submitTimeStr == null ? 43 : $submitTimeStr.hashCode());
        LocalDateTime $lastSubmitTime = this.getLastSubmitTime();
        result = result * 59 + ($lastSubmitTime == null ? 43 : ((Object)$lastSubmitTime).hashCode());
        String $lastSubmitTimeStr = this.getLastSubmitTimeStr();
        result = result * 59 + ($lastSubmitTimeStr == null ? 43 : $lastSubmitTimeStr.hashCode());
        String $baseCityId = this.getBaseCityId();
        result = result * 59 + ($baseCityId == null ? 43 : $baseCityId.hashCode());
        String $baseCityName = this.getBaseCityName();
        result = result * 59 + ($baseCityName == null ? 43 : $baseCityName.hashCode());
        String $taskNo = this.getTaskNo();
        result = result * 59 + ($taskNo == null ? 43 : $taskNo.hashCode());
        String $taskName = this.getTaskName();
        result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
        String $taskApplyStatus = this.getTaskApplyStatus();
        result = result * 59 + ($taskApplyStatus == null ? 43 : $taskApplyStatus.hashCode());
        String $actName = this.getActName();
        result = result * 59 + ($actName == null ? 43 : $actName.hashCode());
        String $actNo = this.getActNo();
        result = result * 59 + ($actNo == null ? 43 : $actNo.hashCode());
        BigDecimal $eqva = this.getEqva();
        result = result * 59 + ($eqva == null ? 43 : ((Object)$eqva).hashCode());
        String $workType = this.getWorkType();
        result = result * 59 + ($workType == null ? 43 : $workType.hashCode());
        LocalDate $workDate = this.getWorkDate();
        result = result * 59 + ($workDate == null ? 43 : ((Object)$workDate).hashCode());
        LocalDate $weekStartDate = this.getWeekStartDate();
        result = result * 59 + ($weekStartDate == null ? 43 : ((Object)$weekStartDate).hashCode());
        LocalDate $weekEndDate = this.getWeekEndDate();
        result = result * 59 + ($weekEndDate == null ? 43 : ((Object)$weekEndDate).hashCode());
        BigDecimal $totalManday = this.getTotalManday();
        result = result * 59 + ($totalManday == null ? 43 : ((Object)$totalManday).hashCode());
        BigDecimal $totalWorkHour = this.getTotalWorkHour();
        result = result * 59 + ($totalWorkHour == null ? 43 : ((Object)$totalWorkHour).hashCode());
        String $apprStatus = this.getApprStatus();
        result = result * 59 + ($apprStatus == null ? 43 : $apprStatus.hashCode());
        String $tsTaskIden = this.getTsTaskIden();
        result = result * 59 + ($tsTaskIden == null ? 43 : $tsTaskIden.hashCode());
        String $tsActIden = this.getTsActIden();
        result = result * 59 + ($tsActIden == null ? 43 : $tsActIden.hashCode());
        String $tsActIdenDesc = this.getTsActIdenDesc();
        result = result * 59 + ($tsActIdenDesc == null ? 43 : $tsActIdenDesc.hashCode());
        String $settleStatus = this.getSettleStatus();
        result = result * 59 + ($settleStatus == null ? 43 : $settleStatus.hashCode());
        String $apprResult = this.getApprResult();
        result = result * 59 + ($apprResult == null ? 43 : $apprResult.hashCode());
        String $workDayOffStatus = this.getWorkDayOffStatus();
        result = result * 59 + ($workDayOffStatus == null ? 43 : $workDayOffStatus.hashCode());
        String $ext1 = this.getExt1();
        result = result * 59 + ($ext1 == null ? 43 : $ext1.hashCode());
        String $ext2 = this.getExt2();
        result = result * 59 + ($ext2 == null ? 43 : $ext2.hashCode());
        String $ext3 = this.getExt3();
        result = result * 59 + ($ext3 == null ? 43 : $ext3.hashCode());
        String $ext5 = this.getExt5();
        result = result * 59 + ($ext5 == null ? 43 : $ext5.hashCode());
        BigDecimal $eqvaRatio = this.getEqvaRatio();
        result = result * 59 + ($eqvaRatio == null ? 43 : ((Object)$eqvaRatio).hashCode());
        BigDecimal $eqvaTimeSheet = this.getEqvaTimeSheet();
        result = result * 59 + ($eqvaTimeSheet == null ? 43 : ((Object)$eqvaTimeSheet).hashCode());
        String $acceptMethod = this.getAcceptMethod();
        result = result * 59 + ($acceptMethod == null ? 43 : $acceptMethod.hashCode());
        LocalDateTime $approvalTime = this.getApprovalTime();
        result = result * 59 + ($approvalTime == null ? 43 : ((Object)$approvalTime).hashCode());
        String $approvalTimeStr = this.getApprovalTimeStr();
        result = result * 59 + ($approvalTimeStr == null ? 43 : $approvalTimeStr.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        String $operPlanName = this.getOperPlanName();
        result = result * 59 + ($operPlanName == null ? 43 : $operPlanName.hashCode());
        String $projNo = this.getProjNo();
        result = result * 59 + ($projNo == null ? 43 : $projNo.hashCode());
        String $projName = this.getProjName();
        result = result * 59 + ($projName == null ? 43 : $projName.hashCode());
        String $taskPackageNo = this.getTaskPackageNo();
        result = result * 59 + ($taskPackageNo == null ? 43 : $taskPackageNo.hashCode());
        String $taskPackageName = this.getTaskPackageName();
        result = result * 59 + ($taskPackageName == null ? 43 : $taskPackageName.hashCode());
        String $stageNo = this.getStageNo();
        result = result * 59 + ($stageNo == null ? 43 : $stageNo.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $reasonType = this.getReasonType();
        result = result * 59 + ($reasonType == null ? 43 : $reasonType.hashCode());
        return result;
    }

    public String toString() {
        return "PmsTimesheetExcel(workDateStr=" + this.getWorkDateStr() + ", tsStatus=" + this.getTsStatus() + ", tsStatusDesc=" + this.getTsStatusDesc() + ", tsUserId=" + this.getTsUserId() + ", tsUserIdName=" + this.getTsUserIdName() + ", tsUserBuId=" + this.getTsUserBuId() + ", tsUserBuName=" + this.getTsUserBuName() + ", jobsName=" + this.getJobsName() + ", reasonName=" + this.getReasonName() + ", projectBuName=" + this.getProjectBuName() + ", stageName=" + this.getStageName() + ", ext4=" + this.getExt4() + ", ext4Desc=" + this.getExt4Desc() + ", workHour=" + this.getWorkHour() + ", workHourStr=" + this.getWorkHourStr() + ", subsidyAmt=" + this.getSubsidyAmt() + ", subsidyAmtStr=" + this.getSubsidyAmtStr() + ", workDesc=" + this.getWorkDesc() + ", apprUserIdName=" + this.getApprUserIdName() + ", submitTime=" + this.getSubmitTime() + ", submitTimeStr=" + this.getSubmitTimeStr() + ", lastSubmitTime=" + this.getLastSubmitTime() + ", lastSubmitTimeStr=" + this.getLastSubmitTimeStr() + ", baseCityId=" + this.getBaseCityId() + ", baseCityName=" + this.getBaseCityName() + ", taskId=" + this.getTaskId() + ", taskNo=" + this.getTaskNo() + ", taskName=" + this.getTaskName() + ", taskApplyStatus=" + this.getTaskApplyStatus() + ", actId=" + this.getActId() + ", actName=" + this.getActName() + ", actNo=" + this.getActNo() + ", eqva=" + this.getEqva() + ", workType=" + this.getWorkType() + ", workDate=" + this.getWorkDate() + ", weekStartDate=" + this.getWeekStartDate() + ", weekEndDate=" + this.getWeekEndDate() + ", yearWeek=" + this.getYearWeek() + ", totalManday=" + this.getTotalManday() + ", totalWorkHour=" + this.getTotalWorkHour() + ", apprStatus=" + this.getApprStatus() + ", tsTaskIden=" + this.getTsTaskIden() + ", tsActIden=" + this.getTsActIden() + ", tsActIdenDesc=" + this.getTsActIdenDesc() + ", settleStatus=" + this.getSettleStatus() + ", apprResult=" + this.getApprResult() + ", workDayOffStatus=" + this.getWorkDayOffStatus() + ", workPlanId=" + this.getWorkPlanId() + ", ext1=" + this.getExt1() + ", ext2=" + this.getExt2() + ", ext3=" + this.getExt3() + ", ext5=" + this.getExt5() + ", eqvaRatio=" + this.getEqvaRatio() + ", eqvaTimeSheet=" + this.getEqvaTimeSheet() + ", acceptMethod=" + this.getAcceptMethod() + ", approvalTime=" + this.getApprovalTime() + ", approvalTimeStr=" + this.getApprovalTimeStr() + ", remark=" + this.getRemark() + ", operPlanId=" + this.getOperPlanId() + ", operPlanName=" + this.getOperPlanName() + ", projId=" + this.getProjId() + ", projNo=" + this.getProjNo() + ", projName=" + this.getProjName() + ", taskPackageId=" + this.getTaskPackageId() + ", taskPackageNo=" + this.getTaskPackageNo() + ", taskPackageName=" + this.getTaskPackageName() + ", stageId=" + this.getStageId() + ", stageNo=" + this.getStageNo() + ", type=" + this.getType() + ", apprUserId=" + this.getApprUserId() + ", reasonId=" + this.getReasonId() + ", reasonType=" + this.getReasonType() + ")";
    }
}

