package com.elitesland.tw.tw5.api.prd.acc.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 科目模板明细管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Getter
@Setter
public class AccSubjectTemplateDetailPayload extends TwCommonPayload implements Serializable {
    /**
     * 模板id
     */
    @ApiModelProperty("模板id")
    private Long tmplId;
    /**
     * 核算项目id
     */
    @ApiModelProperty("核算项目id")
    private Long businessId;
    /**
     * 预算项目id
     */
    @ApiModelProperty("预算项目id")
    private Long budgetId;
    /**
     * 会计科目id
     */
    @ApiModelProperty("会计科目id")
    private Long accId;
    /**
     * 是否考核
     */
    @ApiModelProperty("是否考核")
    private Boolean examineFlag;
    /**
     * 是否包含
     */
    @ApiModelProperty("是否包含")
    private Integer includeFlag;
    /**
     * 是否控制
     */
    @ApiModelProperty("是否控制")
    private Integer controlFlag;
    /**
     * 处理状态
     */
    @ApiModelProperty("处理状态")
    private String procStatus;
    /**
     * 处理信息
     */
    @ApiModelProperty("处理信息")
    private String procInfo;
    /**
     * 处理时间
     */
    @ApiModelProperty("处理时间")
    private LocalDateTime procTime;
    /**
     * 可配置字段1
     */
    @ApiModelProperty("可配置字段1")
    private String extStr1;
    /**
     * 可配置字段2
     */
    @ApiModelProperty("可配置字段2")
    private String extStr2;
    /**
     * 可配置字段3
     */
    @ApiModelProperty("可配置字段3")
    private String extStr3;
    /**
     * 可配置字段4
     */
    @ApiModelProperty("可配置字段4")
    private String extStr4;
    /**
     * 可配置字段5
     */
    @ApiModelProperty("可配置字段5")
    private String extStr5;
}
