package com.elitesland.tw.tw5.api.prd.acc.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimPayBatchPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimPayBatchQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimPayBatchVO;

import java.util.List;

/**
 * 费用报销记账/付款导出管理
 *
 * @author sunxw
 * @date 2023-12-01
 */
public interface AccReimPayBatchService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccReimPayBatchVO}>
     */
    PagingVO<AccReimPayBatchVO> queryPaging(AccReimPayBatchQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccReimPayBatchVO}>
     */
    List<AccReimPayBatchVO> queryListDynamic(AccReimPayBatchQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AccReimPayBatchVO}
     */
    AccReimPayBatchVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AccReimPayBatchVO}
     */
    AccReimPayBatchVO insert(AccReimPayBatchPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AccReimPayBatchVO}
     */
    AccReimPayBatchVO update(AccReimPayBatchPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AccReimPayBatchPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
