package com.elitesland.tw.tw5.api.prd.acc.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@Data
@ExcelIgnoreUnannotated
public class AccReimFinancialExportVO {

    @ApiModelProperty("报销单号")
    @ExcelProperty(value = "报销单号",index = 0)
    private String reimNo;

    @ApiModelProperty("报销导出批次号，T_ACC_PAY_BATCH.BATCH_NO")
    @ExcelProperty(value = "批次号",index = 1)
    private String batchNo;


    @ApiModelProperty("申请日期")
    private LocalDate applyDate;

    @ApiModelProperty("申请日期")
    @ExcelProperty(value = "申请日期",index = 2)
    private String applyDateStr;

    public String getApplyDateStr(){
        if(applyDate!=null){
            return  applyDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return applyDateStr;
    }

    @ExcelProperty(value = "报销申请人",index = 3)
    private String reimUserName;

    @ApiModelProperty("报销总额")
    @ExcelProperty(value = "报销费用",index = 4)
    private BigDecimal reimTotalAmt;

    @ApiModelProperty("调整后费用")
    @ExcelProperty(value = "调整后费用",index = 5)
    private BigDecimal adjustAmt;

    @ExcelProperty(value = "报销单状态",index = 6)
    private String reimStatusName;

    @ApiModelProperty("财务收单时间")
    private LocalDateTime finChargeUpTime;

    @ApiModelProperty("财务收单时间")
    @ExcelProperty(value = "收单时间",index = 7)
    private String finChargeUpTimeStr;

    public String getFinChargeUpTimeStr(){
        if(finChargeUpTime!=null){
            return  finChargeUpTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        return finChargeUpTimeStr;
    }

    @ExcelProperty(value = "审批状态",index = 8)
    private String apprStatusName;

    @ExcelProperty(value = "单据类型",index = 9)
    private String reimDocTypeName;

    @ExcelProperty(value = "事由类型",index = 10)
    private String reasonTypeName;

    @ApiModelProperty("事由名称")
    @ExcelProperty(value = "事由名称",index = 11)
    private String reasonName;

    @ApiModelProperty("财务负责人审批时间")
    private LocalDateTime finPicApprTime;

    @ApiModelProperty("财务负责人审批时间")
    @ExcelProperty(value = "财务负责人审批时间",index = 12)
    private String finPicApprTimeStr;

    public String getFinPicApprTimeStr(){
        if(finPicApprTime!=null){
            return  finPicApprTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        return finPicApprTimeStr;
    }

    @ApiModelProperty("财务记账审批时间")
    private LocalDateTime accountingDate;

    @ApiModelProperty("财务记账审批时间")
    @ExcelProperty(value = "财务记账审批时间",index = 13)
    private String accountingDateStr;

    public String getAccountingDateStr(){
        if(accountingDate!=null){
            return  accountingDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return accountingDateStr;
    }

    @ApiModelProperty("费用承担BU")
    @ExcelProperty(value = "费用承担BU",index = 14)
    private String expenseOrgName;

    @ApiModelProperty("是否有票")
    private Boolean invFlag;

    @ExcelProperty(value = "是否有票",index = 15)
    private String invFlagStr;

    public String getInvFlagStr(){
        if(invFlag){
            return  "有";
        }
        return "无";
    }

    @ExcelProperty(value = "发票法人公司",index = 16)
    private String expenseCompanyName;

    @ExcelProperty(value = "支付状态",index = 17)
    private String payStatusName;

    @ExcelProperty(value = "支付方式",index = 18)
    private String payModeName;

    @ApiModelProperty("付款日期")
    private LocalDateTime payDate;

    @ApiModelProperty("付款日期")
    @ExcelProperty(value = "付款日期",index = 19)
    private String payDateStr;

    public String getPayDateStr(){
        if(payDate!=null){
            return  payDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return payDateStr;
    }

    /**
     * 记录创建时间
     */
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("创建时间")
    @ExcelProperty(value = "创建时间",index = 20)
    private String createTimeStr;

    public String getCreateTimeStr(){
        if(createTime!=null){
            return  createTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        return createTimeStr;
    }

}
