package com.elitesland.tw.tw5.api.prd.cal.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 核算-账号功能管理
 *
 * @author carl
 * @date 2023-11-13
 */
@Getter
@Setter
public class CalAccountQuery extends TwQueryParam implements Serializable {


    /**
     * 主键 精确
     */
    @ApiModelProperty("主键")
    private Long id;
    /**
     * 账号年度 精确
     */
    @ApiModelProperty("账号年度")
    private Integer ledgerYear;
    /**
     * 是否等于账号年度
     */
    @ApiModelProperty("账号年度")
    private Integer ledgerYearFlag;
    /**
     * 账户名称 模糊
     */
    @ApiModelProperty("账户名称")
    private String ledgerName;
    /**
     * 账户状态(1有效 0无效)
     */
    @ApiModelProperty("账户状态(1有效 0无效)")
    private Integer ledgerStatus;
    /**
     * （账户类型）核算主体类型 精确
     */
    @ApiModelProperty("（账户类型）核算主体类型")
    private String auType;
    /**
     * （账户类型）核算主体类型 精确
     */
    @ApiModelProperty("（账户类型）核算主体类型")
    private List<String> auTypes;
    /**
     * 核算主体id 精确
     */
    @ApiModelProperty("核算主体id")
    private Long auId;
    /**
     * 账号编号 精确
     */
    @ApiModelProperty("账号编号")
    private String ledgerNo;
    /**
     * 精确
     */
    @ApiModelProperty("")
    private String ledgerType;
    /**
     * 币种 精确
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 总数量 精确
     */
    @ApiModelProperty("总数量")
    private BigDecimal totalQty;
    /**
     * 全部数据（慎用），1：处理正数数据，-1：处理负数数据
     */
    @ApiModelProperty("操作类型")
    private String operType;
    /**
     * 冻结数量 精确
     */
    @ApiModelProperty("冻结数量")
    private BigDecimal frozenQty;
    /**
     * 可用数量 精确
     */
    @ApiModelProperty("可用数量")
    private BigDecimal avalQty;
    /**
     * 总金额 精确
     */
    @ApiModelProperty("总金额")
    private BigDecimal totalAmt;
    /**
     * 冻结金额 精确
     */
    @ApiModelProperty("冻结金额")
    private BigDecimal frozenAmt;
    /**
     * 可用金额 精确
     */
    @ApiModelProperty("可用金额")
    private BigDecimal avalAmt;
    /**
     * 账号编号 精确
     */
    @ApiModelProperty("账号编号")
    private List<String> ledgerNos;
}
