package com.elitesland.tw.tw5.api.prd.crm.service;


import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityAnalyzePayload;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityAnalyzeVO;

import java.util.List;


/**
 * @author carl.wang
 * @Description:商机案情分析管理
 */
public interface CrmOpportunityAnalyzeService {

    /**
     * @param payload
     * @Description 新增
     **/
    CrmOpportunityAnalyzeVO insert(CrmOpportunityAnalyzePayload payload);

    /**
     * @param payload
     * @Description 修改
     **/
    Long update(CrmOpportunityAnalyzePayload payload);


    /**
     * @param oppoId 商机id
     * @return
     * @Description 列表查询
     **/
    List<CrmOpportunityAnalyzeVO> queryList(Long oppoId);


    /**
     * @param keys   主键
     * @param oppoId 商机id
     * @Description 删除
     **/
    boolean deleteSoft(Long oppoId, List<Long> keys);
}

