package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitescloud.boot.common.param.BaseViewModel;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 客户经营-经营计划明细表
 *
 * @author duwh
 * @date 2022/11/15
 */
@Data
public class CrmOperationPlanDetailVO extends BaseViewModel {

    /**
     * 客户经营主键 crm_customer_operation.id
     */
    private Long operId;
    /**
     * 客户经营 名称
     */
    private String custName;

    /**
     * 主表id 预留字段 暂无用
     */
    private Long planId;

    /**
     * 计划名称
     */
    private String planName;

    /**
     * 计划内容
     */
    private String planContent;

    /**
     * 开始时间
     */
    private LocalDateTime startTime;

    /**
     * 结束时间
     */
    private LocalDateTime endTime;

    /**
     * 优先级 udc[crm:oper_plan:priority]
     */
    private String priority;
    @UdcName(udcName = "crm:oper_plan:priority", codePropName = "priority")
    private String priorityDesc;

    /**
     * 状态 udc[crm:oper_plan:status]
     */
    private String status;
    @UdcName(udcName = "crm:oper_plan:status", codePropName = "status")
    private String statusDesc;

    /**
     * 客户经营状态
     */
    private String custOperStatus;

    /**
     * 执行者 id
     */
    private Long performerId;
    /**
     * 执行者
     */
    @UdcName(udcName = "USER", codePropName = "performerId")
    private String performerName;

    /**
     * 经营计划参与者
     */
    private List<CrmOperationPlanDetailMemberVO> memberList;

    /**
     * 评论个数
     */
    private Long comments = 0L;

    /**
     * 附件个数
     */
    private Long files = 0L;

    private String ext1;

    private String ext2;

    private String ext3;

    private String ext4;

    private String ext5;

    /**
     * 客户经营部门
     */
    private Long custOperBu;
    @UdcName(udcName = "BU", codePropName = "custOperBu")
    private String custOperBuName;

    /**
     * 客户经营部负责人
     */
    private Long custOperManagerId;
    @UdcName(udcName = "USER", codePropName = "custOperManagerId")
    private String custOperManagerName;

    /**
     * 销售经营部门
     */
    private Long saleOperBu;
    @UdcName(udcName = "BU", codePropName = "saleOperBu")
    private String saleOperBuName;

    /**
     * 销售经营部负责人
     */
    private Long saleOperManagerId;
    @UdcName(udcName = "USER", codePropName = "saleOperManagerId")
    private String saleOperManagerName;
}
