package com.elitesland.tw.tw5.api.prd.my.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
* 工作计划模板
*
* @author duwh
* @date 2022-12-15
*/
@Data
public class TimesheetPlanTempPayload extends TwCommonPayload  {

    /** 工作计划主键 */
    private Long planId;
    /** 状态 */
    private String status;
    /** 拓展1 */
    private String ext1;
    /** 拓展2 */
    private String ext2;
    /** 拓展3 */
    private String ext3;
    /** 拓展4 */
    private String ext4;
    /** 拓展5 */
    private String ext5;
    /** 类型 PROJ 项目 TASK 任务 */
    private String type;
    /** 项目id */
    private Long projId;
    /** 项目名称 */
    private String projName;
    /** 项目编号 */
    private String projNo;
    @ApiModelProperty("事由id")
    private Long reasonId;
    @ApiModelProperty("事由名称")
    private String reasonName;
    @ApiModelProperty("事由类型 01 项目 02 售前 03 bu")
    private String reasonType;
    /** 任务包id */
    private Long taskPackageId;
    /** 任务包编号 冗余 */
    private String taskPackageNo;
    /** 任务包名称冗余 */
    private String taskPackageName;
    /** 任务id */
    private Long taskId;
    /** 任务编号 */
    private String taskNo;
    /** 任务编号 */
    private String taskName;
    /** 任务包申请状态 */
    private String taskApplyStatus;
    /** 任务当量 */
    private BigDecimal eqvaQty;
    /** 活动id */
    private Long actId;
    /** 活动名称冗余 */
    private String actName;
    /** 活动编号冗余 */
    private String actNo;
}
