package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitesland.tw.tw5.api.prd.my.payload.AbnormalWorkApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.my.query.AbnormalWorkApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.AbnormalWorkApplyDetailVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 远程办公申请明细
 *
 * @author wangly
 * @date 2024-06-12
 */
public interface AbnormalWorkApplyDetailService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AbnormalWorkApplyDetailVO}>
     */
    PagingVO<AbnormalWorkApplyDetailVO> queryPaging(AbnormalWorkApplyDetailQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AbnormalWorkApplyDetailVO}>
     */
    List<AbnormalWorkApplyDetailVO> queryListDynamic(AbnormalWorkApplyDetailQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AbnormalWorkApplyDetailVO}
     */
    AbnormalWorkApplyDetailVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AbnormalWorkApplyDetailVO}
     */
    AbnormalWorkApplyDetailVO insert(AbnormalWorkApplyDetailPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AbnormalWorkApplyDetailVO}
     */
    AbnormalWorkApplyDetailVO update(AbnormalWorkApplyDetailPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AbnormalWorkApplyDetailPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
