package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TBusiCardApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TBusiCardApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TBusiCardApplyVO;

import java.util.List;

/**
 * 名片申请
 *
 * @author lemon
 * @date 2023-09-11
 */
public interface TBusiCardApplyService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TBusiCardApplyVO}>
     */
    PagingVO<TBusiCardApplyVO> queryPaging(TBusiCardApplyQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TBusiCardApplyVO}>
     */
    List<TBusiCardApplyVO> queryListDynamic(TBusiCardApplyQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TBusiCardApplyVO}
     */
    TBusiCardApplyVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TBusiCardApplyVO}
     */
    TBusiCardApplyVO insert(TBusiCardApplyPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TBusiCardApplyVO}
     */
    TBusiCardApplyVO update(TBusiCardApplyPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TBusiCardApplyPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
