package com.elitesland.tw.tw5.api.prd.my.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 远程办公审批配置
 *
 * @author wangly
 * @date 2024-06-13
 */
@Getter
@Setter
public class AbnormalWorkApplyConfigVO extends BaseViewModel implements Serializable {
    /**
     * 事由类型
     */
    @ApiModelProperty("事由类型")
    private String reasonType;

    @ApiModelProperty("事由类型")
    @UdcName(udcName = "PMS:PROJECT:TYPE", codePropName = "triggerCondition")
    private String reasonTypeDesc;
    /**
     * 触发条件
     */
    @ApiModelProperty("触发条件")
    private String triggerCondition;
    /**
     * 触发条件
     */
    @ApiModelProperty("触发条件")
    @UdcName(udcName = "prd:timesheet:triggerCondition", codePropName = "triggerCondition")
    private String triggerConditionDesc;
    /**
     * 触发天数
     */
    @ApiModelProperty("触发天数")
    private BigDecimal conditionDays;
    /**
     * 业务角色1
     */
    @ApiModelProperty("业务角色1")
    private String firstRoleType;

    /**
     * 业务角色1
     */
    @ApiModelProperty("业务角色1")
    @UdcName(udcName = "ABNORMAL_WORK:ROLE_TYPE", codePropName = "firstRoleType")
    private String firstRoleTypeDesc;
    /**
     * 审批角色1
     */
    @ApiModelProperty("审批角色1")
    private String firstApprovePerson;
    /**
     * 审批角色1
     */
    @ApiModelProperty("审批角色1")
    @UdcName(udcName = "prd:timesheet:business_role", codePropName = "firstApprovePerson")
    private String firstApprovePersonDesc;
    /**
     * 业务角色2
     */
    @ApiModelProperty("业务角色2")
    private String twiceRoleType;

    /**
     * 业务角色2
     */
    @ApiModelProperty("业务角色2")
    @UdcName(udcName = "ABNORMAL_WORK:ROLE_TYPE", codePropName = "twiceRoleType")
    private String twiceRoleTypeDesc;
    /**
     * 审批角色2
     */
    @ApiModelProperty("审批角色2")
    private String twiceApprovePerson;

    /**
     * 审批角色2
     */
    @ApiModelProperty("审批角色2")
    @UdcName(udcName = "prd:timesheet:business_role", codePropName = "twiceApprovePerson")
    private String twiceApprovePersonDesc;
    /**
     * 业务角色3
     */
    @ApiModelProperty("业务角色3")
    private String thirdRoleType;
    /**
     * 业务角色3
     */
    @ApiModelProperty("业务角色3")
    @UdcName(udcName = "ABNORMAL_WORK:ROLE_TYPE", codePropName = "thirdRoleType")
    private String thirdRoleTypeDesc;
    /**
     * 审批角色3
     */
    @ApiModelProperty("审批角色3")
    private String thirdApprovePerson;

    /**
     * 审批角色3
     */
    @ApiModelProperty("审批角色3")
    @UdcName(udcName = "prd:timesheet:business_role", codePropName = "thirdApprovePerson")
    private String thirdApprovePersonDesc;
    /**
     * 业务角色4
     */
    @ApiModelProperty("业务角色4")
    private String fourthRoleType;
    /**
     * 业务角色4
     */
    @ApiModelProperty("业务角色4")
    @UdcName(udcName = "ABNORMAL_WORK:ROLE_TYPE", codePropName = "fourthRoleType")
    private String fourthRoleTypeDesc;
    /**
     * 审批角色4
     */
    @ApiModelProperty("审批角色4")
    private String fourthApprovePerson;

    /**
     * 审批角色4
     */
    @ApiModelProperty("审批角色4")
    @UdcName(udcName = "prd:timesheet:business_role", codePropName = "fourthApprovePerson")
    private String fourthApprovePersonDesc;
    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字段4
     */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /**
     * 扩展字段5
     */
    @ApiModelProperty("扩展字段5")
    private String ext5;
}
