package com.elitesland.tw.tw5.api.prd.my.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

/**
 * 双周计划
 *
 * @author duwh
 * @date 2022-12-21
 */
@Data
public class TimesheetBiweeklyVO extends BaseViewModel {

    /**
     * 提交人
     */
    private Long tsUserId;
    @UdcName(udcName = "USER", codePropName = "tsUserId")
    private String tsUserName;
    /**
     * 标题
     */
    private String title;
    /**
     * 双周计划类型
     */
    private String tsbType;
    /**
     * 双周计划Buid
     */
    private Long tsbBuId;
    @UdcName(udcName = "BU", codePropName = "tsbBuId")
    private String tsbBuName;
    /**
     * 发送对象
     */
    private String receiveUserIds;
    /**
     * 是否已读 0 未读  1已读
     */
    private Integer isRead;
    /**
     * 拓展1
     */
    private String ext1;
    /**
     * 拓展2
     */
    private String ext2;
    /**
     * 拓展3
     */
    private String ext3;
    /**
     * 本周开始日期
     */
    private LocalDate startWeekDate;
    /**
     * 本周结束日期
     */
    private LocalDate endWeekDate;
    /**
     * 所在年周
     */
    private Integer yearWeek;
    /**
     * 提交人用户id
     */
    private Long createUserId;
    /**
     * 提交人
     */
    @UdcName(udcName = "USER", codePropName = "createUserId")
    private String createUserName;

    /**
     * 明细列表
     */
    private List<TimesheetBiweeklyDetailVO> detailList;
}
