package com.elitesland.tw.tw5.api.prd.partner.common.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookInvoicePayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookInvoiceVO;

import java.util.List;

/**
 * 业务伙伴-发票信息
 *
 * @author wangly
 * @date 2023-05-16
 */
public interface BookInvoiceService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BookInvoiceVO}>
     */
    PagingVO<BookInvoiceVO> queryPaging(BookInvoiceQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BookInvoiceVO}>
     */
    List<BookInvoiceVO> queryListDynamic(BookInvoiceQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BookInvoiceVO}
     */
    BookInvoiceVO queryByKey(Long key);

    /**
     * 根据bookId查询默认
     *
     * @param bookId bookId
     * @return {@link BookInvoiceVO}
     */
    BookInvoiceVO queryDefaultByBookId(Long bookId);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @param logFlag 是否需要操作记录日志
     * @return {@link BookInvoiceVO}
     */
    BookInvoiceVO insert(BookInvoicePayload payload, Boolean logFlag);

    /**
     * 批量新增
     *
     * @param voList 单据数据
     * @return {@link BookInvoiceVO}
     */
    void batchInsert(List<BookInvoiceVO> voList);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @param logFlag 是否需要操作记录日志
     * @return {@link BookInvoiceVO}
     */
    BookInvoiceVO update(BookInvoicePayload payload,Boolean logFlag);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys,Long bookId,Long partnerId,Boolean logFlag);

    //逻辑删除（直接删除 不关心默认值的处理）
    void deleteSoftBykeys(List<Long> keys,Long bookId,Long partnerId);


    /**
     * 查询数量
     *
     * @param query 单据数据
     * @return Long 条数
     */

    Long count(BookInvoiceQuery query);


    /**
     * 逻辑删除
     *
     * @param bookId 地址薄id
     * @return Long 条数
     */
    void deleteByBookId(Long bookId);

//    /**
//     * 4.0同步发票信息查询
//     *
//     * @param bookIdList 地址薄id
//     * @return Long 条数
//     */
//    List<PrdAbInvoicePayload> queryTwBookInvoiceListByBookId(List<Long> bookIdList);

    /**
     * 逻辑删除
     *
     * @param bookInvoicVoList 发票集合
     *
     */
    void saveAll(List<BookInvoiceVO> bookInvoicVoList);
}
