package com.elitesland.tw.tw5.api.prd.partner.common.vo;

import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

@Getter
@Setter
public class BusinessConfirmedCustomerVO implements Serializable {
    /**
     * 客户id
     */
    @ApiModelProperty("客户id")
    private Long id;
    /**
     * 业务伙伴id
     */
    @ApiModelProperty("业务伙伴id")
    private Long partnerId;
    /**
     * 地址簿id
     */
    @ApiModelProperty("地址簿id")
    private Long bookId;
    /**
     * 业务伙伴编号
     */
    @ApiModelProperty("业务伙伴编号")
    private String businessPartnerNo;

    /**
     * 业务伙伴名称
     */
    @ApiModelProperty("业务伙伴名称")
    private String partnerName;

    /**
     * 客户级别 udc[crm:customer_grade]
     */
    @ApiModelProperty("客户级别 udc[crm:customer_grade]")
    private String customerGradle;

    @ApiModelProperty("客户级别 udc[crm:customer_grade]")
    @UdcName(udcName = "crm:customer_grade", codePropName = "customerGradle")
    private String customerGradleDesc;

    /**
     * 客户状态
     */
    @ApiModelProperty("客户状态")
    private String customerStatus;

    /**
     * 客户状态 udc[CRM:BUSINESS_PARTNER:STATUS]
     */
    @ApiModelProperty("客户状态 udc[CRM:BUSINESS_PARTNER:STATUS]")
    @UdcName(udcName = "CRM:BUSINESS_PARTNER:STATUS", codePropName = "customerStatus")
    private String customerStatusDesc;

    /**
     * 行业 udc[crm:leads_customer_industry]
     */
    @ApiModelProperty("行业 udc[crm:leads_customer_industry]")
    private String partnerIndustry;
    /**
     * 行业 udc[crm:leads_customer_industry]
     */

    @ApiModelProperty("行业描述 udc[crm:leads_customer_industry]")
    @UdcName(udcName = "crm:leads_customer_industry", codePropName = "partnerIndustry")
    private String partnerIndustryDesc;

    /**
     * 客户来源 udc[crm:customer_source]
     */
    @ApiModelProperty("客户来源 udc[crm:customer_source]")
    private String customerSource;

    /**
     * 客户来源 udc[crm:customer_source]
     */
    @ApiModelProperty("客户来源 udc[crm:customer_source]")
    @UdcName(udcName = "crm:customer_source", codePropName = "customerSource")
    private String customerSourceDesc;

    /**
     * 邮箱
     */
    @ApiModelProperty("邮箱")
    private String partnerEmail;
    /**
     * 传真
     */
    @ApiModelProperty("传真")
    private String partnerFax;
    /**
     * 电话
     */
    @ApiModelProperty("电话")
    private String partnerPhone;

    /**
     * 省
     */
    @ApiModelProperty("省")
    private String province;
    /**
     * 市
     */
    @ApiModelProperty("市")
    private String city;
    /**
     * 区
     */
    @ApiModelProperty("区")
    private String district;
    /**
     * 省
     */
    @ApiModelProperty("省")
    private String provinceName;
    /**
     * 市
     */
    @ApiModelProperty("市")
    private String cityName;
    /**
     * 区
     */
    @ApiModelProperty("区")
    private String districtName;
    /**
     * 省市区
     */
    @ApiModelProperty("省市区")
    private String address;

    /**
     * 服务负责人
     */
    @ApiModelProperty("服务负责人")
    private Long serviceUserId;

    /**
     * 服务负责人
     */
    @ApiModelProperty("服务负责人")
    private String serviceUserName;
}
