package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 资源计划角色明细
 *
 * @author xxb
 * @date 2023-08-11
 */
@Getter
@Setter
public class PmsResourcePlanRolePayload extends TwCommonPayload implements Serializable {
    /**
     * 关联资源计划ID
     */
    @ApiModelProperty("关联资源计划ID")
    private Long planId;
    /**
     * 角色
     */
    @ApiModelProperty("角色")
    private String role;
    /**
     * 复合能力级别ID
     */
    @ApiModelProperty("复合能力级别ID")
    private Long capasetLevelId;
    /**
     * 资源
     */
    @ApiModelProperty("资源")
    private Long resId;
    /**
     * 资源状态
     */
    @ApiModelProperty("资源状态")
    private String planRoleStatus;
    /**
     * 派发系数
     */
    @ApiModelProperty("派发系数")
    private BigDecimal distributeRate;
    /**
     * 开始日期
     */
    @ApiModelProperty("开始日期")
    private LocalDate startDate;
    /**
     * 结束日期
     */
    @ApiModelProperty("结束日期")
    private LocalDate endDate;
    /**
     * 汇总人天
     */
    @ApiModelProperty("汇总人天")
    private BigDecimal totalDays;
    /**
     * 汇总当量
     */
    @ApiModelProperty("汇总当量")
    private BigDecimal totalEqva;
    /**
     * 隐藏标志
     */
    @ApiModelProperty("隐藏标志 0 展示 1隐藏")
    private Integer hiddenFlag;

//    /**
//     * 持续周数
//     */
//    @ApiModelProperty("持续周数")
//    private Integer durationWeek;

//
//    @ApiModelProperty("日期相关")
//    private Map<String, String> yearWeek;

    @ApiModelProperty("天数")
    private BigDecimal[] days;

    /** 以下是预留字段 */

//    /** 推荐资源id */
//    @ApiModelProperty("推荐资源id")
//    private Long recommendResId;
//    /** 读取状态 */
//    @ApiModelProperty("读取状态")
//    private String readStatus;
//    /** 预计日期 */
//    @ApiModelProperty("预计日期")
//    private LocalDate expectedDate;
}
