package com.elitesland.tw.tw5.api.prd.task.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 任务
 *
 * @author xxb
 * @date 2023-11-16
 */
@Getter
@Setter
public class TaskPackageQuery extends TwQueryParam implements Serializable {

    @ApiModelProperty("事由id")
    private Long reasonId;
    @ApiModelProperty("事由名称")
    private String reasonName;
    @ApiModelProperty("事由类型 01 项目 02 售前 03 bu")
    private String reasonType;
    @ApiModelProperty("事由类型 01 项目 02 售前 03 bu")
    private List<String> reasonTypes;
    /**
     * 任务包名称
     */
    @ApiModelProperty(value = "任务包名称")
    private String taskPackageName;

    /**
     * 发包资源id
     */
    @ApiModelProperty(value = "发包资源id")
    private Long disterResId;

    /**
     * 接收资源id
     */
    @ApiModelProperty(value = "接收资源id")
    private Long receiverResId;
    /**
     * 接收资源id
     */
    @ApiModelProperty(value = "接收资源id")
    private List<Long> receiverResIds;

    @ApiModelProperty("接收资源bu_id")
    private Long receiverBuId;

    /**
     * 接收资源复合能力ID
     */
    @ApiModelProperty(value = "接收资源复合能力ID")
    private Long compositeAbilityId;
    /**
     * 工种
     */
    @ApiModelProperty("工种")
    private String jobType1;

    /**
     * 工种子类
     */
    @ApiModelProperty("工种子类")
    private String jobType2;

    /**
     * 任务包开始日期
     */
    @ApiModelProperty(value = "任务包开始日期")
    private LocalDate startDate;

    /**
     * 任务包结束日期
     */
    @ApiModelProperty(value = "任务包结束日期")
    private LocalDate endDate;

    /**
     * 任务包状态
     */
    @ApiModelProperty(value = "任务包状态")
    private String taskPackageStatus;

    /**
     * 任务包类型
     */
    @ApiModelProperty(value = "任务包类型")
    private String taskPackageType;

    /**
     * 任务包说明
     */
    @ApiModelProperty(value = "任务包说明")
    private String taskPackageDes;

    /**
     * 结算信息
     */

    /**
     * 验收人
     */
    @ApiModelProperty(value = "验收人")
    private Long acceptorId;

    /**
     * 验收方式
     */
    @ApiModelProperty(value = "验收方式")
    private String acceptMethod;

    /**
     * 计价方式
     */
    @ApiModelProperty(value = "计价方式")
    private String pricingMethod;

    /**
     * 定时任务自动结算当量标记
     */
    @ApiModelProperty(value = "定时任务自动结算当量标记")
    private Integer autoSettleFlag;

    /**
     * 质保金比例
     */
    @ApiModelProperty(value = "质保金比例")
    private BigDecimal guaranteeRate;

    /**
     * 当量结算单价
     */
    @ApiModelProperty(value = "当量结算单价")
    private BigDecimal settlePrice;

    /**
     * 当量收入单价
     */
    @ApiModelProperty(value = "当量收入单价")
    private BigDecimal incomePrice;


    /**
     * 主键ids
     */
    @ApiModelProperty("主键ids")
    private List<Long> ids;
}
