package com.elitesland.tw.tw5.api.prd.ts.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;


/**
  * notask_approval_1
  *
  * @author zoey
  * @date 2024-04-30
  */
@Getter
@Setter
public class TsNotaskApprovalConfigRuleVO extends BaseViewModel implements Serializable {
    /** 报配置主表id */
    @ApiModelProperty("报配置主表id")
    private Long configId;
    /** 活动 */
    @ApiModelProperty("活动")
    private String activity;

    /** 活动 */
    @ApiModelProperty("活动")
    private String activityName;

    /** 用户配置 */
    @ApiModelProperty("用户配置")
    private Integer isUser;
    /** 人员 */
    @ApiModelProperty("人员")
    private String users;

    /** 人员 */
    @ApiModelProperty("人员")
    private String usersName;

    /** 范围（udc:每人，事业部） */
    @ApiModelProperty("范围（udc:每人，事业部）")
    private String scope;
    /** 范围（udc:每人，事业部） */
    @ApiModelProperty("范围（udc:每人，事业部）")
    @UdcName(udcName = "prd:timesheet:scope", codePropName = "scope")
    private String scopeDesc;

    /** 填报天数上限 */
    @ApiModelProperty("填报天数上限")
    private BigDecimal upperLimit;
    /** UT值 */
    @ApiModelProperty("UT值")
    private Integer ut;
    /** 触发条件 */
    @ApiModelProperty("触发条件")
    private String triggerCondition;
    /** 触发条件 */
    @ApiModelProperty("触发条件")
    @UdcName(udcName = "prd:timesheet:triggerCondition", codePropName = "triggerCondition")
    private String triggerConditionDesc;

    /** 条件触发的天数 */
    @ApiModelProperty("条件触发的天数")
    private BigDecimal conditionDays;

    /** 审批人id */
    @ApiModelProperty("审批人id")
    private Long apprUserId;

    /** 报配置主表id */
    @ApiModelProperty("报配置主表id")
    @UdcName(udcName = "USER", codePropName = "apprUserId")
    private String apprUserName;

    /** 审批1角色 */
    @ApiModelProperty("审批1角色")
    private String firstApprUserRole;
}
