/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.api.common.util;

import cn.hutool.core.lang.Assert;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.stereotype.Component;

@Component
public class DataSourceUtil {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceUtil.class);
    private final DataSourceProperties dataSourceProperties;

    public DataSource getDs() {
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl((String)Assert.notBlank((CharSequence)this.dataSourceProperties.getUrl(), (String)"dataHub\u7684\u6570\u636e\u5e93url\u4e3a\u7a7a", (Object[])new Object[0]));
        ds.setDriverClassName((String)Assert.notBlank((CharSequence)this.dataSourceProperties.getDriverClassName(), (String)"dataHub\u7684\u6570\u636e\u5e93\u9a71\u52a8\u4e3a\u7a7a", (Object[])new Object[0]));
        ds.setUsername((String)Assert.notBlank((CharSequence)this.dataSourceProperties.getUsername(), (String)"dataHub\u7684\u6570\u636e\u5e93\u7528\u6237\u540d\u4e3a\u7a7a", (Object[])new Object[0]));
        ds.setPassword((String)Assert.notBlank((CharSequence)this.dataSourceProperties.getPassword(), (String)"dataHub\u7684\u6570\u636e\u5e93\u5bc6\u7801\u4e3a\u7a7a", (Object[])new Object[0]));
        ds.setAutoCommit(false);
        return ds;
    }

    public DataSourceUtil(DataSourceProperties dataSourceProperties) {
        this.dataSourceProperties = dataSourceProperties;
    }
}

