package com.elitesland.tw.tw5.api.prd.cal.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 当量收入配置管理
 *
 * @author carl
 * @date 2023-11-07
 */
@Getter
@Setter
public class CalEqvaIncomeQuery extends TwQueryParam implements Serializable {
    /**
     * 主键 精确
     */
    @ApiModelProperty("主键")
    private Long id;
    /**
     * buid
     */
    @ApiModelProperty("buid")
    private Long buId;
    /**
     * 核算年度 精确
     */
    @ApiModelProperty("核算年度")
    private Integer finYear;
    /**
     * 核算期间
     */
    @ApiModelProperty("核算期间")
    private Integer finPeriod;
    /**
     * 工种 精确
     */
    @ApiModelProperty("工种")
    private String jobType1;
    /**
     * 工种子类 精确
     */
    @ApiModelProperty("工种子类")
    private String jobType2;
    /**
     * 合作方式 精确
     */
    @ApiModelProperty("合作方式")
    private String coopType;
    /**
     * 城市级别 精确
     */
    @ApiModelProperty("城市级别")
    private String cityLevel;
    /**
     * 单位当量收入 精确
     */
    @ApiModelProperty("单位当量收入")
    private BigDecimal preeqvaAmt;
    /**
     * 状态1：有效，0无效
     */
    @ApiModelProperty("状态")
    private String lineStatus;
    /**
     * 项目id 精确
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 资源id 精确
     */
    @ApiModelProperty("资源id")
    private Long resId;
    /**
     * 资源类型1内部，0外部
     */
    @ApiModelProperty("资源类型1内部，0外部")
    private String resType;

    /**
     * 起始时间
     */
    @ApiModelProperty("起始时间")
    private LocalDate startDate;

    /**
     * 结算方式 udc[org:employee:withdrawSettleMethod]
     */
    @ApiModelProperty("结算方式 udc[org:employee:withdrawSettleMethod]")
    private String settleType;

    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer version;
}
