package com.elitesland.tw.tw5.api.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationMemberListPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationMemberPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationMemberQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationMemberVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * 客户经营-经营团队成员
 *
 * @author duwh
 * @date 2022/11/15
 */
public interface CrmCustomerOperationMemberService {

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link CrmCustomerOperationMemberVO}
     */
    CrmCustomerOperationMemberVO insert(CrmCustomerOperationMemberPayload payload);

    /**
     * 保存或更新所有
     *
     * @param payload 有效载荷
     * @return {@link List}<{@link CrmCustomerOperationMemberVO}>
     */
    List<CrmCustomerOperationMemberVO> saveAll(CrmCustomerOperationMemberListPayload payload);

    /**
     * 根据客户经营主键 删除
     *
     * @param operId ③id
     */
    void deleteSoftByOperId(Long operId);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link CrmCustomerOperationMemberVO}
     */
    CrmCustomerOperationMemberVO update(CrmCustomerOperationMemberPayload payload);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    CrmCustomerOperationMemberVO queryByKey(Long key);

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link List}<{@link CrmCustomerOperationMemberVO}>
     */
    List<CrmCustomerOperationMemberVO> queryList(CrmCustomerOperationMemberQuery query);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<CrmCustomerOperationMemberVO> paging(CrmCustomerOperationMemberQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);


}
