package com.elitesland.tw.tw5.api.prd.humanresources.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdLevelConfigDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdLevelConfigDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdLevelConfigDtlVO;

import java.util.List;


/**
 * @author : WWW
 * @date : 2023-10-18
 * @desc : 级别维护明细表Service
 */

public interface PrdLevelConfigDtlService {

    /**
     * 新增级别维护明细表数据
     * @param prdLevelConfigDtlPayload
     * @return
     */
    PrdLevelConfigDtlVO save(PrdLevelConfigDtlPayload prdLevelConfigDtlPayload);

    /**
     * 根据主键更新
     * @param prdLevelConfigDtlPayload
     * @return
     */
    PrdLevelConfigDtlVO update(PrdLevelConfigDtlPayload prdLevelConfigDtlPayload);

    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    PrdLevelConfigDtlVO get(Long id);

    /**
     * 分页查询列表
     * @param prdLevelConfigDtlQuery
     * @return
     */
    PagingVO<PrdLevelConfigDtlVO> page(PrdLevelConfigDtlQuery prdLevelConfigDtlQuery);

    /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);


    /**
     * 根据masId删除
     * @param id
     * @return
     */
    Long delByMasId(Long id);
}

