package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.RewardLeaveConfigPayload;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveConfigQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardLeaveConfigVO;

import java.util.List;

public interface RewardLeaveConfigService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link RewardLeaveConfigVO}>
     */
    PagingVO<RewardLeaveConfigVO> queryPaging(RewardLeaveConfigQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link RewardLeaveConfigVO}>
     */
    List<RewardLeaveConfigVO> queryListDynamic(RewardLeaveConfigQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link RewardLeaveConfigVO}
     */
    RewardLeaveConfigVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link RewardLeaveConfigVO}
     */
    RewardLeaveConfigVO insert(RewardLeaveConfigPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link RewardLeaveConfigVO}
     */
    RewardLeaveConfigVO update(RewardLeaveConfigPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(RewardLeaveConfigPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 查询Bu奖励假配置
     *
     * @param query
     * @return
     */
    List<RewardLeaveConfigVO> queryBuConfig(RewardLeaveConfigQuery query);

}

