package com.elitesland.tw.tw5.api.prd.org.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.util.List;
import java.util.Set;


@Data
public class PrdOrgEmployeeQuery extends TwQueryParam {

    /**
     * 员工id列表
     */
    private Long[] employeeIds;

    /**
     * 员工编号
     */
    @ApiModelProperty("员工编号")
    private String employeeNo;
    /**
     * 员工名称
     */
    @ApiModelProperty("员工名称")
    private String personName;
    /**
     * 账户状态
     */
    private Boolean enabled;
    /**
     * 组织Id
     */
    @ApiModelProperty("组织ID")
    private Long orgId;

    /**
     * 资源状态
     */
    @ApiModelProperty("资源状态")
    private String resourceStatus;

    /**
     * 资源状态
     */
    @ApiModelProperty("资源状态")
    private List<String> resourceStatusIn;

    /**
     * 资源状态
     */
    @ApiModelProperty("资源状态")
    private String resourceStatusList;
    /**
     * 人事状态
     */
    @ApiModelProperty("人事状态")
    private String hrStatus;//0：有效，1：无效
    /**
     * 入职日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("入职日期")
    private LocalDate enrollDate;
    /**
     * 安全级别
     */
    @ApiModelProperty("安全级别")
    private Integer accessLevel;
    /**
     * 岗位
     */
    @ApiModelProperty("岗位")
    private String jobs;
//    /**
//     * 公司
//     */
//    @ApiModelProperty("公司")
//    private Long companyId;

    /**
     * 公司
     */
    @ApiModelProperty("公司")
    private Long bookId;
    /**
     * 专业级别
     */
    private String extString1;
    /**
     * 管理级别
     */
    private String extString2;
    /**
     * 专业序列
     */
    private String extString3;
    /**
     * 职位序列
     */
    private String extString4;
    /**
     * 主服务地址
     */
    private String extString5;
    /**
     * 内部类型
     */
    private String extString6;
    /**
     * 话费额度
     */
    private String extString7;
    /**
     * 电脑额度
     */
    private String extString8;
    private String extString9;
    private String extString10;
    private String extString11;
    private String extString12;
    /**
     * 离职日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate extDate1;
    /**
     * 转正日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate extDate2;
    /**
     * 合同签订日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate extDate3;
    /**
     * 合同到期日
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate extDate4;
    /**
     * 实习入职日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate extDate5;
    /**
     * 试用期开始
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate extDate6;
    /**
     * 试用期结束
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate extDate7;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate extDate8;

    /**
     * 导出类型 model:模板，data:数据
     */
    private String downloadType;
    /**
     * 系统角色ids
     */
    private List<Long> roleIds;

    /**
     * 用户id
     */
    private List<Long> userIds;

    /**
     * 是否需要权限判断
     */
    private Boolean isPermission = true;

    /**
     * 用户id
     */
    private Set<Long> userIdList;

    /**
     * 功能主键
     */
    private Long functionId;

    /**
     * 角色名称
     */
    private String roleName;

    /**
     * 模糊字段
     */
    private String keyword;

    @ApiModelProperty("合作方式")
    private String cooperationMode;

    @ApiModelProperty("组织标志")
    private Boolean orgIdFlag;

}
