package com.elitesland.tw.tw5.api.prd.personplan.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVO;

import java.util.List;


 /**
  * @author : WWW
  * @date : 2024-2-21
  * @desc : 人员规划Service
  */
public interface PersonPlanService {
    
    /**
     * 新增人员规划数据
     * @param personPlanPayload
     * @return
     */
    PersonPlanVO save(PersonPlanPayload personPlanPayload);
    
    /**
     * 根据主键更新
     * @param personPlanPayload
     * @return
     */
    PersonPlanVO updateAll(PersonPlanPayload personPlanPayload);
    
    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    PersonPlanVO get(Long id);
    
    /**
     * 分页查询列表
     * @param personPlanQuery
     * @return
     */
    PagingVO<PersonPlanVO> page(PersonPlanQuery personPlanQuery);
    
    /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);
    
    /**
     * 获取列表查询
     * @param personPlanQuery
     * @return
     */
    List<PersonPlanVO> getList(PersonPlanQuery personPlanQuery);
    
    /**
     * 根据条件修改
     * @param personPlanPayload
     * @return
     */
    Long update(PersonPlanPayload personPlanPayload);

     /**
      * 根据关联对象id和规划类型查询
      * @param objId
      * @param planTypeList
      * @return
      */
     PersonPlanVO getByObjIdAndPlanType(Long objId,List<String> planTypeList);

     /**
      * 保存新版本
      * @param personPlanPayload
      * @return
      */
     void saveNewVersion(PersonPlanPayload personPlanPayload);

     /**
      * 将原来的资源规划数据迁移为pms的数据
      * @param
      * @return
      */
     void transferData();
 }

