package com.elitesland.tw.tw5.api.prd.purchase.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;


/**
 * 采购协议关联资源
 *
 * @author lemon
 * @date 2023-11-02
 */
@Getter
@Setter
public class PurchaseAgreementResVO extends BaseViewModel implements Serializable {
    /**
     * 资源ID
     */
    @ApiModelProperty("资源ID")
    private Long resId;

    @ApiModelProperty("资源")
    @UdcName(udcName = "USER", codePropName = "resId")
    private String resName;
    /**
     * 采购协议单据ID
     */
    @ApiModelProperty("采购协议单据ID")
    private Long documentId;
    /**
     * 采购协议单据编号
     */
    @ApiModelProperty("采购协议单据编号")
    private String documentNo;
    /**
     * 资源开始日期
     */
    @ApiModelProperty("资源开始日期")
    private LocalDate resStartDate;
    /**
     * 资源结束日期
     */
    @ApiModelProperty("资源结束日期")
    private LocalDate resEndDate;
}
