package com.elitesland.tw.tw5.api.prd.sale.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Data;

/**
 * 合同类别
 *
 * @author duwh
 * @date 2022/09/27
 */
@Data
public class SaleContractCategoryQuery extends TwQueryParam {

    /**
     * 名称
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String name;

    /**
     * 类别编号
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String categoryNo;

    /**
     * 图标
     */
    @Query()
    private String icon;

    /**
     * 隐藏标志 0：不隐藏，1：隐藏
     */
    @Query()
    private Integer hiddenFlag;

    /**
     * 排序
     */
    private Integer sortNo;

}
