package com.elitesland.tw.tw5.api.prd.salecon.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;


/**
 * invdtl
 *
 * @author zoey
 * @date 2023-08-02
 */
@Getter
@Setter
public class ConInvBatchInvdtlVO extends BaseViewModel implements Serializable {
    /**
     * 开票批次ID
     */
    @ApiModelProperty("开票批次ID")
    private Long invbatchId;
    /**
     * 发票号
     */
    @ApiModelProperty("发票号")
    private String invNo;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 发票金额
     */
    @ApiModelProperty("发票金额")
    private BigDecimal invAmt;
    /**
     * 发票状态
     */
    @ApiModelProperty("发票状态")
    private String invStatus;
    /**
     * 快递单号
     */
    @ApiModelProperty("快递单号")
    private String deliveryNo;
    /**
     * 快递日期
     */
    @ApiModelProperty("快递日期")
    private LocalDate deliveryDate;
    /**
     * 发票来源（null:手工插入）
     */
    @ApiModelProperty("发票来源（null:手工插入）")
    private String comeFrom;
    /**
     * 发票下载地址（null:手工插入无地址）
     */
    @ApiModelProperty("发票下载地址（null:手工插入无地址）")
    private String downloadUrl;

    /**
     * 实际开票日期
     */
    private LocalDate actualInvDate;

    /**
     * 税率
     */
    private BigDecimal taxRate;

    /**
     * 开票主体公司ID
     */
    @ApiModelProperty("开票主体公司ID")
    private Long invOuId;
    /**
     * 开票主体公司ID
     */
    @ApiModelProperty("开票主体公司名称")
    private String invOuName;

    /**
     * 开票人
     */
    @ApiModelProperty("开票人")
    private Long invUserId;//开票人

    /**
     * 开票人
     */
    @ApiModelProperty("开票人")
    @UdcName(udcName = "USER", codePropName = "invUserId")
    private String invUserName;//开票人

    /**
     * JDE客户编号
     */
    @ApiModelProperty("JDE客户编号")
    private String customerNo;

    /**
     * 子合同号
     */
    @ApiModelProperty("子合同号")
    private String subContractNo;

    /**
     * 工作类型
     */
    @ApiModelProperty("工作类型")

    private String workType;


    @UdcName(udcName = "salecon:work_type", codePropName = "workType")
    private String workTypeDesc;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String custName;

    /**
     * 客户地址簿号
     */
    @ApiModelProperty("客户地址簿号")
    private String custBookNo;

    /**
     * 发票抬头
     */
    @ApiModelProperty("发票抬头")
    private String invTitle;
    /**
     * 发票类型
     */
    @ApiModelProperty("发票类型")
    private String invType;
    /**
     * 发票类型
     */
    @ApiModelProperty("发票类型")
    @UdcName(udcName = "prd:ab:inv_type", codePropName = "invType")
    private String invTypeDesc;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 退票记录的合同id
     */
    private Long saleContractId;

    /**
     * 开票状态
     */
    private String batchStatus;
}
