package com.elitesland.tw.tw5.api.prd.visit.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 销售拜访计划
 *
 * @author liwenpeng
 * @date 2023-03-14
 */
@Getter
@Setter
@JsonInclude(JsonInclude.Include.NON_NULL)
public class VisitPlanVO extends BaseViewModel implements Serializable {

    /**
     * 创建人名称
     */
    @ApiModelProperty("创建人名称")
    private String createUserName;

    /**
     * 计划类型
     */
    @ApiModelProperty("计划类型")
    private String visitPlanType;
    private String visitPlanTypeDesc;

    @ApiModelProperty("计划状态")
    private String visitPlanStatus;
    private String visitPlanStatusDesc;
    /**
     * 计划名称
     */
    @ApiModelProperty("计划名称")
    private String visitPlanName;
    /**
     * 拜访客户id see partnerId
     */
    @ApiModelProperty("拜访客户id see partnerId")
    @Deprecated
    private Long customId;

    /**
     * 业务伙伴主键（客户主表） business_partner.id
     */
    @ApiModelProperty("业务伙伴主键（客户主表） business_partner.id")
    private Long partnerId;

    /**
     * 地址 联系人 账户 开票信息关联字段
     */
    @ApiModelProperty("bookId")
    private Long bookId;
    /**
     * 客户地址
     */
    @ApiModelProperty("客户地址")
    private String customAdress;

    /**
     * 客户阶段
     */
    @ApiModelProperty("客户阶段")
    private String customerStage;

    /**
     * 业务合作伙伴-地址信息ID
     */
    @ApiModelProperty("业务合作伙伴-地址信息ID")
    private Long bookAddressId;

    /**
     * 业务合作伙伴-地址信息Desc
     */
    @ApiModelProperty("业务合作伙伴-地址信息ID")
    private String bookAddressDesc;

    private String customerName;

    @ApiModelProperty("详细地址")
    private String companyAddress;
    @ApiModelProperty("经纬度")
    private String longitudeLatitude;
    /**
     * 联系人姓名
     */
    private String contactsName;
    /**
     * 联系人手机
     */
    private String contactsPhone;

    /**
     * 拜访时间
     */
    @ApiModelProperty("拜访时间")
    private LocalDate visitDateFrom;
    /**
     * 拜访时间
     */
    @ApiModelProperty("拜访时间")
    private LocalDate visitDateTo;

    private String visitDate;
    /**
     * 拜访次数
     */
    @ApiModelProperty("拜访次数")
    private String visitTimes;
    /**
     * 添加提醒
     */
    @ApiModelProperty("添加提醒")
    private LocalDateTime remindTime;
    private String extString1;
    private String extString2;
    private String extString3;
    private String extString4;
    private String extString5;
    /**
     * 关联信息类型（线索、商机OPPO、经营计划、销售目标）
     */
    @ApiModelProperty("关联信息类型（线索、商机OPPO、经营计划、销售目标）")
    private String objType;
    private String objTypeDesc;
    /**
     * 关联信息主键（关联主键)
     */
    @ApiModelProperty("关联信息主键（关联主键)")
    private Long objId;
    /**
     * 关联信息名称（冗余）
     */
    @ApiModelProperty("关联信息名称（冗余）")
    private String objName;

    /**
     * 拜访人员列表
     */
    private List<Long> visitPersonList;
    private String visitPersonNameStr;

    /**
     * 协访人员列表
     */
    private List<Long> accompanyPersonList;
    private String accompanyPersonNameStr;
}
