package com.elitesland.tw.tw5.api.prd.cal.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettleDetailPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalTaskSettleDetailQuery;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalTaskSettleDetailVO;

import java.util.List;

/**
 * 任务包
 *
 * @author carl
 * @date 2023-11-15
 */
public interface CalTaskSettleDetailService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link CalTaskSettleDetailVO}>
     */
    PagingVO<CalTaskSettleDetailVO> queryPaging(CalTaskSettleDetailQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link CalTaskSettleDetailVO}>
     */
    List<CalTaskSettleDetailVO> queryListDynamic(CalTaskSettleDetailQuery query);


    /**
     * 批量新增或修改
     *
     * @param payloads 单据数据
     */
    List<CalTaskSettleDetailVO> bacthInsert(List<CalTaskSettleDetailPayload> payloads);

    /**
     * 根据结算单id逻辑删除
     *
     * @param settleIds 出差id
     */
    void deleteSoftBySettleId(List<Long> settleIds);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(CalTaskSettleDetailPayload payload);

    /**
     * 查询任务在指定状态下的结算明细数据
     *
     * @param taskIds
     * @param statuss
     * @return
     */
    List<String> queryTaskSettleDetails(List<Long> taskIds, List<String> statuss);
}
