package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 礼品单
 *
 * @author xxb
 * @date 2023-08-31
 */
@Getter
@Setter
public class CrmGiftListPayload extends TwCommonPayload implements Serializable {
    /**
     * 礼品单编号
     */
    @ApiModelProperty("礼品单编号")
    private String giftNo;
    /**
     * 礼品类型 一级
     */
    @ApiModelProperty("礼品类型 一级")
    private String giftType1;
    /**
     * 礼品类型 二级
     */
    @ApiModelProperty("礼品类型 二级")
    private String giftType2;
    /**
     * 特殊申请用户标志
     */
    @ApiModelProperty("特殊申请用户标志")
    private Integer specialUsersFlag;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("流程提交标志")
    private Boolean submitFlag = false;

    /**
     * 申请状态
     */
    @ApiModelProperty("申请状态")
    private String applyStatus;

    @ApiModelProperty("礼品明细")
    private List<CrmGiftInfoPayload> crmGiftInfoPayloads;

    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;

    /**
     * 申请用户ID
     */
    @ApiModelProperty("申请用户ID")
    private  Long applyUserId;

    /**
     * 申请人bu
     */
    @ApiModelProperty("申请人bu")
    private Long applyUserBuId;

    /**
     * 创建人bu
     */
    @ApiModelProperty("创建人bu")
    private Long createUserBuId;

}
