package com.elitesland.tw.tw5.api.prd.crm.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActActivityPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActDynamicPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActReportPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmActActivityQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActActivityVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActDynamicVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActProjectVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActReportVO;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectMemberVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;


/**
 * @author carl.wang
 * @Description:市场活动管理
 */
public interface CrmActActivityService {
    /**
     * 定时任务处理逾期邮件
     */
    void activityUnReleaseJobHandler();

    /**
     * @return
     * @Description 分页查询
     **/
    PagingVO<CrmActActivityVO> queryPagingUnReleased(CrmActActivityQuery query);

    /**
     * 获取创建人待发布的活动公告
     *
     * @param userId
     * @return
     */
    Map<String, Object> findActivityUnReleaseByUserId(long userId);

    /**
     * 不发布公告
     *
     * @param id
     */
    void refuseRelease(Long id);

    /**
     * @param payload
     * @Description 新增活动
     **/
    CrmActActivityVO insert(CrmActActivityPayload payload);

    /**
     * @param payload
     * @Description 修改活动
     **/
    Long update(CrmActActivityPayload payload);

    /**
     * @param keys 主键ids
     * @return boolean
     * @Description 逻辑删除
     **/
    boolean deleteSoft(List<Long> keys);

    /**
     * @param query
     * @return
     * @Description 分页查询
     **/
    PagingVO<CrmActActivityVO> paging(CrmActActivityQuery query);

    /**
     * 批量导出活动excel
     *
     * @param response 请求响应
     * @param query    查询条件
     */
    void downloadActivitys(HttpServletResponse response, CrmActActivityQuery query);

    /**
     * @param planId 计划id
     * @return
     * @Description 列表查询
     **/
    List<CrmActProjectVO> queryList(Long planId);

    /**
     * @param key 主键
     * @return
     * @Description 主键查询
     **/
    CrmActActivityVO queryByKey(Long key);

    /**
     * @param key
     * @return
     */
    List<CrmActDynamicVO> queryDynamicByKey(Long key);

    List<PrjProjectMemberVO> queryMembersByKey(Long key);


    /**
     * @param key 主键
     * @return
     * @Description 主键结项报告
     **/
    List<CrmActReportVO> queryReportByKey(Long key, Integer reportType);

    /**
     * @param key       活动主键
     * @param userId    变更人userId
     * @param opeStatus 变更操作
     * @return boolean
     * @Description 修改负责人
     **/
    boolean changeManger(Long key, Long userId, Integer opeStatus);

    /**
     * @param key 活动主键
     * @return boolean
     * @Description 修改锁定状态
     **/
    boolean changeLockStatus(Long key);

    /**
     * @param key     活动主键
     * @param userIds 用户ids
     * @return List<PrjProjectMemberVO>
     * @Description 活动新增成员
     **/
    List<PrjProjectMemberVO> addMember(Long key, List<Long> userIds);

    /**
     * @param keys 主键
     * @return
     * @Description 活动删除成员
     **/
    boolean deleteMember(Long actId, List<Long> keys);

    /**
     * @param payload 跟进payload
     * @return List<CrmActDynamicVO>
     * @Description 新增活动动态跟进
     **/
    List<CrmActDynamicVO> addDynamic(CrmActDynamicPayload payload);

    /**
     * @param payload 跟进payload
     * @return
     * @Description 修改活动动态跟进
     **/
    boolean updateDynamic(CrmActDynamicPayload payload);

    /**
     * @param key 主键
     * @return
     * @Description 跟进动态详情查询
     **/
    CrmActDynamicVO queryActDynamicDetail(Long key);

    /**
     * @param key         活动主键
     * @param closeType   关闭原因
     * @param clsoeRemark 关闭备注
     * @return boolean
     * @Description 活动关闭
     **/
    boolean closeActivity(Long key, String closeType, String clsoeRemark);

    /**
     * @param key 主键
     * @return
     * @Description 获取汇报数据
     **/
    CrmActReportVO queryActReportData(Long key);

    /**
     * @param payload 跟进payload
     * @return CrmActReportVO
     * @Description 新增活动情况汇报
     **/
    CrmActReportVO addReport(CrmActReportPayload payload);

    /**
     * @param actId 活动主键
     * @return
     * @Description 获取汇报数据列表
     **/
    List<CrmActReportVO> queryActReportList(Long actId, Integer reportType);

    /**
     * @param key 汇报数据主键
     * @return
     * @Description 获取汇报数据详情
     **/
    CrmActReportVO queryActReportDetail(Long key);

    void updateWorkFlowStatus(Long projectId, String status, String procInstId);


    /**
     * 市场活动日志列表
     *
     * @param activityId
     * @return
     */
    Object changeLogList(Long activityId);

    /**
     * 根据活动id,查询当前变更数据
     *
     * @param activityId
     * @return
     */
    Object changeLogDetailByActivityId(Long activityId);


    List<CrmActActivityVO> queryListDynamic(CrmActActivityQuery query);

    void updateSchedule(Long id, Long scheduleId);
}

