package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author zoey
 * @Description:线索客户表，保存线索的客户信息
 * @date 2022/5/17 - 17:12
 */
@Data
public class CrmLeadsCustomerVO extends BaseViewModel {
    /**
     * 线索id
     */
    @JsonSerialize(
            using = ToStringSerializer.class
    )
    private Long leadsId;

    /**
     * 客户名称
     */
    private String customerName;

    /**
     * 客户行业
     */
    private String customerIndustry;
    private String customerIndustryDesc;


    /**
     * 客户级别
     */
    private String customerGrade;
    private String customerGradeDesc;

    /**
     * 客户联系人
     */
    private String customerContacts;

    /**
     * 联系人部门
     */
    private String contactsDepartment;

    /**
     * 联系人岗位
     */
    private String contactsPosition;

    /**
     * 联系人电话
     */
    private String contactsPhone;

    /**
     * 联系人邮箱
     */
    private String contactsEmail;

    /**
     * 客户区域
     */
    private String custRegion;
    private String custRegionDesc;

    /**
     * 销售产品
     */
    private String saleProduct;

}
