package com.elitesland.tw.tw5.api.prd.humanresources.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResWithdrawApplyPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ResWithdrawApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResWithdrawApplyInfo;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResWithdrawApplyVO;

import java.util.List;

public interface ResWithdrawApplyService {

    /**
     * 资源提现申请提交
     *
     * @param payload
     * @return
     */
    void submit(ResWithdrawApplyPayload payload);

    /**
     * 资源提现申请查询
     *
     * @param
     * @return
     */
    ResWithdrawApplyVO queryByProcId(String procId);

    /**
     * 资源提现申请列表分页
     *
     * @param
     * @return
     */
    PagingVO<ResWithdrawApplyVO> page(ResWithdrawApplyQuery query);

    /**
     * 资源提现申请详情查询
     *
     * @param
     * @return
     */
    ResWithdrawApplyVO queryByKey(Long id);

    /**
     * 根据采购协议编号查询提现申请
     * @param agreementNo 采购协议编号
     * @return 提现申请VO
     */
    List<ResWithdrawApplyVO> findWithdrawByAgreementNo(String agreementNo);

    /**
     * 更新提现单的状态以及付款申请单id
     * @param paymentApplyId 付款申请单id
     * @param withdrawIds 提现单ids
     * @param withdrawStatus 提现单ids
     */
    void updateWithdrawStatusAndPaymentApplyIdByIds(Long paymentApplyId, List<Long> withdrawIds, String withdrawStatus);

    /**
     * 根据付款申请单id修改提现申请单状态
     * @param paymentApplyId 付款申请单id
     * @param withdrawStatus 提现申请单状态
     */
    void updateWithdrawStatusByPaymentApplyId(Long paymentApplyId, String withdrawStatus);

    /**
     * 根据付款申请单id查询提现申请单列表
     * @param paymentApplyId 付款申请单id
     */
    List<ResWithdrawApplyVO> queryListByPaymentApplyId(Long paymentApplyId);
    /**
     * 资源提现申请分页(付款用)
     *
     * @param
     * @return
     */
    ResWithdrawApplyInfo getResWithdrawTotal(ResWithdrawApplyQuery query);

}
