package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

/**
* 双周计划明细
*
* @author duwh
* @date 2022-12-21
*/
@Data
public class TimesheetBiweeklyDetailQuery extends TwQueryParam{
    /** 双周计划id 精确 */
    @Query
    private Long tsbId;
    /** 类型 10 本周预计工作 20 本周实际工作 30 预计下周工作 精确 */
    @Query
    private String type;
    /** 精确 */
    @Query
    private Long projId;
    /** 项目名称 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String projectName;
    /** 精确 */
    @Query
    private Long taskId;
    /** 任务名称 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String taskName;
    /** 精确 */
    @Query
    private Long actId;
    /** 活动名称 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String actName;
    /** 工作说明 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String workDesc;
    /** 所在年周 */
    @Query
    private Integer yearWeek;
    /** 拓展1 精确 */
    @Query
    private String ext1;
    /** 拓展2 精确 */
    @Query
    private String ext2;
    /** 拓展3 精确 */
    @Query
    private String ext3;
    /** 所属日期 BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    private List<LocalDate> tsbDate;
    /**
     * 提交人
     */
    @Query
    private Long createUserId;

}
