package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TAttendanceRecordPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceRecordQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceRecordVO;

import java.time.LocalDate;
import java.util.List;

public interface TAttendanceRecordService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TAttendanceRecordVO}>
     */
    PagingVO<TAttendanceRecordVO> queryPaging(TAttendanceRecordQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TAttendanceRecordVO}>
     */
    List<TAttendanceRecordVO> queryListDynamic(TAttendanceRecordQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TAttendanceRecordVO}
     */
    TAttendanceRecordVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TAttendanceRecordVO}
     */
    TAttendanceRecordVO insert(TAttendanceRecordPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TAttendanceRecordVO}
     */
    TAttendanceRecordVO update(TAttendanceRecordPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TAttendanceRecordPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据人员日期查询打卡信息
     *
     * @param resId
     * @param attendanceDate
     * @return
     */
    List<Long> findResAttendanceLog(Long resId, LocalDate attendanceDate);

    String findStartTime(Long id);

    String findResAttendanceStatus(Long id);

    String findResAttendanceResult(Long id);

    /**
     * 同步4.0的打卡记录明细表到5.0
     */
    void attendanceRecordTo5(String param);
}
