package com.elitesland.tw.tw5.api.prd.partner.business.vo;

import com.elitesland.tw.tw5.api.prd.partner.business.constants.PartnerBusinessTypeEnum;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 业务合作伙伴 业务往来数量统计
 *
 * @author duwh
 * @date 2023/06/07
 */
@Getter
@Setter
public class PartnerBusinessCountVO implements Serializable {

    /**
     * 类型
     */
    private String type;

    /**
     * 名字
     */
    private String name;

    /**
     * 数
     */
    private Integer count = 0;

    /**
     * 图标
     */
    private String icon;

    /**
     * 图标uri
     */
    private String iconUri;

    /**
     * 排序
     */
    private Integer sortNo = 0;

    /** 移动端已占用这个字段，后端不需要再赋值 */
    @Deprecated
    private String ext1;
    private String ext2;
    private String ext3;


    public PartnerBusinessCountVO() {
    }

    public PartnerBusinessCountVO(PartnerBusinessTypeEnum typeEnum, Integer count) {
        this.type = typeEnum.getType();
        this.name = typeEnum.getName();
        this.count = count;
        this.icon = typeEnum.getIcon();
        this.iconUri = typeEnum.getIconUri();
        this.sortNo = typeEnum.getSortNo();
    }


    public PartnerBusinessCountVO(String type, String name, Integer count, String icon, String iconUri, Integer sortNo) {
        this.type = type;
        this.name = name;
        this.count = count;
        this.icon = icon;
        this.iconUri = iconUri;
        this.sortNo = sortNo;
    }

}
