package com.elitesland.tw.tw5.api.prd.purchase.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
    import java.time.LocalDate;
    import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.List;

/**
 * 采购协议
 *
 * @author Echo
 * @date 2023-06-08
 */
@Getter
@Setter
public class PurchaseAgreementQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    @ApiModelProperty("记录唯一ID集合")
    private List<Long> ids;
    /** 采购协议编号 精确 */
    @ApiModelProperty("采购协议编号")
    private String purchaseAgreementNo;
    /** 采购协议名称 模糊 */
    @ApiModelProperty("采购协议名称")
    private String purchaseAgreementName;
    private String purchaseAgreementNameEq;

    private String purchaseAgreementNmNo;
    /** 协议类型 精确 */
    @ApiModelProperty("协议类型 ")
    private String agreementType;
    /** 验收方式 精确 */
    @ApiModelProperty("验收方式 ")
    private String acceptanceType;
    /** 签约日期 精确 */
    @ApiModelProperty("签约日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate signDate;
    /** 申请日期 精确 */
    @ApiModelProperty("申请日期")
    private LocalDate applicationDate;
    /** 签约公司地址簿Id 精确 */
    @ApiModelProperty("签约公司地址簿Id")
    private Long signCompanyBookId;
    /** 签约BU 精确 */
    @ApiModelProperty("签约BU")
    private Long signBuId;
    /** 签约负责人 精确 */
    @ApiModelProperty("签约负责人")
    private Long signInchargeResId;
    /** 供应商地址簿ID 精确 */
    @ApiModelProperty("供应商地址簿ID")
    private Long supplierBookId;
    /** 供应商ID 精确 */
    @ApiModelProperty("供应商ID")
    private Long supplierId;
    /** 币种 精确 */
    @ApiModelProperty("币种 ")
    private String currCode;
    /** 金额 精确 */
    @ApiModelProperty("金额")
    private BigDecimal amt;
    /** 税率 精确 */
    @ApiModelProperty("税率")
    private String taxRate;
    /** 税额 精确 */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /** 协议内容说明 精确 */
    @ApiModelProperty("协议内容说明")
    private String agreementContentDescription;
    /** 比价资料 精确 */
    @ApiModelProperty("比价资料")
    private String pricecompereFileCodes;
    /** 协议附件 精确 */
    @ApiModelProperty("协议附件")
    private String agreementFileCodes;
    /** 盖章附件 精确 */
    @ApiModelProperty("盖章附件")
    private String stampFileCodes;
    /** 开票方 精确 */
    @ApiModelProperty("开票方")
    private Long invoice;
    /** 付款方式 精确 */
    @ApiModelProperty("付款方式")
    private String payMethod;
    /** 协议状态 精确 */
    @ApiModelProperty("协议状态")
    private String agreementStatus;
    /** 协议归属编号 精确 */
    @ApiModelProperty("协议归属编号")
    private String agreementOwnershipNo;
    /** 激活时间 精确 */
    @ApiModelProperty("激活时间")
    private LocalDateTime activateDate;
    /** 前置单据负责人 精确 */
    @ApiModelProperty("前置单据负责人")
    private Long preReceiptResId;
    /** 终止原因 精确 */
    @ApiModelProperty("终止原因")
    private String overReason;
    /** 终止日期 精确 */
    @ApiModelProperty("终止日期")
    private LocalDateTime overDate;
}
