package com.elitesland.tw.tw5.api.prd.purchase.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
    import java.time.LocalDate;
    import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.List;

/**
 * 结算申请明细
 *
 * @author wangly
 * @date 2024-08-21
 */
@Getter
@Setter
public class SettleApplyDetailsQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 采购协议ID */
    @ApiModelProperty("采购协议ID")
    private Long purchaseAgreementId;
    /** 主表ID 精确 */
    @ApiModelProperty("主表ID")
    private Long settleApplyId;
    /** 结算资源ID 精确 */
    @ApiModelProperty("结算资源ID")
    private Long settleResId;
    /** 结算开始日期 精确 */
    @ApiModelProperty("结算开始日期")
    private LocalDate startDate;
    /** 结算结束日期 精确 */
    @ApiModelProperty("结算结束日期")
    private LocalDate endDate;
    /** 合作方式 精确 */
    @ApiModelProperty("合作方式")
    private String coopWay;
    /** 结算人天 精确 */
    @ApiModelProperty("结算人天")
    private BigDecimal settleDays;
    /** 出差天数 精确 */
    @ApiModelProperty("出差天数")
    private BigDecimal businessTripDays;
    /** 事由类型 精确 */
    @ApiModelProperty("事由类型")
    private String reasonType;
    /** 事由id 精确 */
    @ApiModelProperty("事由id")
    private Long reasonId;
    /** 事由名称 精确 */
    @ApiModelProperty("事由名称")
    private String reasonName;
    /** 事由号 精确 */
    @ApiModelProperty("事由号")
    private String reasonNo;
    /** 子合同编号 精确 */
    @ApiModelProperty("子合同编号")
    private String saleContractNo;
    /** 子合同id 精确 */
    @ApiModelProperty("子合同id")
    private Long saleContractId;
    /** 项目归属bu 精确 */
    @ApiModelProperty("项目归属bu")
    private Long projectBelongBu;
    /** 付款时间 精确 */
    @ApiModelProperty("付款时间")
    private LocalDateTime payTime;
    /** 付款金额 精确 */
    @ApiModelProperty("付款金额")
    private BigDecimal payAmt;
    /** 付款状态 精确 */
    @ApiModelProperty("付款状态")
    private String payStatus;
    /** 扩展字段1 精确 */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /** 扩展字段2 精确 */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /** 扩展字段3 精确 */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /** 扩展字4 精确 */
    @ApiModelProperty("扩展字4")
    private String ext4;
    /** 扩展字5 精确 */
    @ApiModelProperty("扩展字5")
    private String ext5;
}
